/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNUpdateTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNUpdateTest.class);

    @Test
    public void testRemoveAndAddSomething() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test", "1.0.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("0001-input-data-string.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        ReleaseId v101 = ks.newReleaseId("org.kie", "dmn-test", "1.0.1");
        KieHelper.createAndDeployJar((KieServices)ks, (ReleaseId)v101, (Resource[])new Resource[]{ks.getResources().newClassPathResource("0001-input-data-string-itIT.dmn", this.getClass())});
        Results updateResults = kieContainer.updateToVersion(v101);
        Assert.assertThat((Object)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR}), (Matcher)CoreMatchers.is((Object)false));
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext2 = runtime.newContext();
        dmnContext2.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll2 = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext2);
        Assert.assertThat((Object)evaluateAll2.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Salve John Doe"));
    }

    @Test
    public void testReplace() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test", "1.0.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("0001-input-data-string.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        ReleaseId v101 = ks.newReleaseId("org.kie", "dmn-test", "1.0.1");
        Resource newClassPathResource = ks.getResources().newClassPathResource("0001-input-data-string-itIT.dmn", this.getClass());
        newClassPathResource.setTargetPath("0001-input-data-string.dmn");
        KieHelper.createAndDeployJar((KieServices)ks, (ReleaseId)v101, (Resource[])new Resource[]{newClassPathResource});
        Results updateResults = kieContainer.updateToVersion(v101);
        Assert.assertThat((Object)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR}), (Matcher)CoreMatchers.is((Object)false));
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext2 = runtime.newContext();
        dmnContext2.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll2 = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext2);
        Assert.assertThat((Object)evaluateAll2.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Salve John Doe"));
    }

    @Test
    public void testReplaceDisposeCreateReplace() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId v100 = ks.newReleaseId("org.kie", "dmn-test", "1.0.0");
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)v100, (Resource[])new Resource[]{ks.getResources().newClassPathResource("0001-input-data-string.dmn", this.getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        ReleaseId v101 = ks.newReleaseId("org.kie", "dmn-test", "1.0.1");
        Resource newClassPathResource = ks.getResources().newClassPathResource("0001-input-data-string-itIT.dmn", this.getClass());
        newClassPathResource.setTargetPath("0001-input-data-string.dmn");
        KieHelper.createAndDeployJar((KieServices)ks, (ReleaseId)v101, (Resource[])new Resource[]{newClassPathResource});
        Results updateResults = kieContainer.updateToVersion(v101);
        Assert.assertThat((Object)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR}), (Matcher)CoreMatchers.is((Object)false));
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext2 = runtime.newContext();
        dmnContext2.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll2 = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext2);
        Assert.assertThat((Object)evaluateAll2.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Salve John Doe"));
        kieContainer.dispose();
        kieContainer = ks.newKieContainer(v100);
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext3 = runtime.newContext();
        dmnContext3.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll3 = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext3);
        Assert.assertThat((Object)evaluateAll3.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Hello John Doe"));
        updateResults = kieContainer.updateToVersion(v101);
        Assert.assertThat((Object)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR}), (Matcher)CoreMatchers.is((Object)false));
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNContext dmnContext4 = runtime.newContext();
        dmnContext4.set("Full Name", (Object)"John Doe");
        DMNResult evaluateAll4 = runtime.evaluateAll((DMNModel)runtime.getModels().get(0), dmnContext4);
        Assert.assertThat((Object)evaluateAll4.getDecisionResultByName("Greeting Message").getResult(), (Matcher)CoreMatchers.is((Object)"Salve John Doe"));
    }

    @Test
    public void testFromClonedKiePackage() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId v100 = ks.newReleaseId("org.kie", "dmn-test", "1.0.0");
        KieHelper.createAndDeployJar((KieServices)ks, (ReleaseId)v100, (Resource[])new Resource[]{ks.getResources().newClassPathResource("0001-input-data-string.dmn", this.getClass())});
        KieContainer kieContainer = ks.newKieContainer(v100);
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        kieContainer.dispose();
        kieContainer = ks.newKieContainer(v100);
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testFromClonedKiePackageThenUpgrade() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId v100 = ks.newReleaseId("org.kie", "dmn-test", "1.0.0");
        KieHelper.createAndDeployJar((KieServices)ks, (ReleaseId)v100, (Resource[])new Resource[]{ks.getResources().newClassPathResource("0001-input-data-string.dmn", this.getClass())});
        KieContainer kieContainer = ks.newKieContainer(v100);
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        kieContainer.dispose();
        kieContainer = ks.newKieContainer(v100);
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
        ReleaseId v101 = ks.newReleaseId("org.kie", "dmn-test", "1.0.1");
        Resource newClassPathResource = ks.getResources().newClassPathResource("0001-input-data-string-itIT.dmn", this.getClass());
        newClassPathResource.setTargetPath("0001-input-data-string.dmn");
        KieHelper.createAndDeployJar((KieServices)ks, (ReleaseId)v101, (Resource[])new Resource[]{newClassPathResource});
        Results updateResults = kieContainer.updateToVersion(v101);
        Assert.assertThat((Object)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR}), (Matcher)CoreMatchers.is((Object)false));
        runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertThat((Object)runtime.getModels(), (Matcher)Matchers.hasSize((int)1));
    }
}

