/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core;

import java.math.BigDecimal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;

public class VacationDaysTest {
    @Test
    public void testSolutionCase1() {
        this.executeTest(16, 1, 27);
    }

    @Test
    public void testSolutionCase2() {
        this.executeTest(25, 5, 22);
    }

    @Test
    public void testSolutionCase3() {
        this.executeTest(44, 20, 24);
    }

    @Test
    public void testSolutionCase4() {
        this.executeTest(44, 30, 30);
    }

    @Test
    public void testSolutionCase5() {
        this.executeTest(50, 20, 24);
    }

    @Test
    public void testSolutionCase6() {
        this.executeTest(50, 30, 30);
    }

    @Test
    public void testSolutionCase7() {
        this.executeTest(60, 20, 30);
    }

    private void executeTest(int age, int yearsService, int expectedVacationDays) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0020-vacation-days.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn", "0020-vacation-days");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)age);
        context.set("Years of Service", (Object)yearsService);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Total Vacation Days"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(expectedVacationDays)));
    }
}

