/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.classloader;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNClassloaderTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNClassloaderTest.class);

    @Test
    public void testClassloaderFunctionInvocation() {
        String javaSource = "package com.acme.functions;\n\nimport org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;\nimport java.math.BigDecimal;\nimport java.util.List;\n\npublic class StandardDeviation {\n\n    public static BigDecimal std( List<Number> values ) {\n        DescriptiveStatistics stats = new DescriptiveStatistics();\n        for( Number value : values ) {\n            stats.addValue( value.doubleValue() );\n        }\n        return new BigDecimal( stats.getStandardDeviation() );\n    }\n}";
        KieServices ks = KieServices.Factory.get();
        ReleaseId kjarReleaseId = ks.newReleaseId("org.kie.dmn.core.classloader", "testClassloaderFunctionInvocation", UUID.randomUUID().toString());
        ReleaseId commonsMathGAV = ks.newReleaseId("org.apache.commons", "commons-math3", "3.6.1");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/java/com/acme/functions/StandardDeviation.java", "package com.acme.functions;\n\nimport org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;\nimport java.math.BigDecimal;\nimport java.util.List;\n\npublic class StandardDeviation {\n\n    public static BigDecimal std( List<Number> values ) {\n        DescriptiveStatistics stats = new DescriptiveStatistics();\n        for( Number value : values ) {\n            stats.addValue( value.doubleValue() );\n        }\n        return new BigDecimal( stats.getStandardDeviation() );\n    }\n}");
        kfs.write(ks.getResources().newClassPathResource("Standard Deviation.dmn", this.getClass()));
        kfs.writePomXML(this.getPom(kjarReleaseId, commonsMathGAV));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertTrue((String)kieBuilder.getResults().getMessages().toString(), (boolean)kieBuilder.getResults().getMessages().isEmpty());
        KieContainer container = ks.newKieContainer(kjarReleaseId);
        DMNRuntime runtime = (DMNRuntime)container.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_48c4b6e2-25da-44bc-97b2-1e842ff28c71", "Standard Deviation");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Values", Arrays.asList(new BigDecimal(1), new BigDecimal(2), new BigDecimal(3)));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.info("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Standard Deviation"), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }
}

