/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.core.compiler.ImportDMNResolverUtil;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.v1_1.Import;

public class ImportDMNResolverUtilTest {
    @Test
    public void testNSonly() {
        Import i = this.makeImport("ns1", null, null);
        List<QName> available = Arrays.asList(new QName("ns1", "m1"), new QName("ns2", "m2"), new QName("ns3", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("ns1", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testNSandModelName() {
        Import i = this.makeImport("ns1", null, "m1");
        List<QName> available = Arrays.asList(new QName("ns1", "m1"), new QName("ns2", "m2"), new QName("ns3", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("ns1", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testNSandModelNameWithAlias() {
        Import i = this.makeImport("ns1", "aliased", "m1");
        List<QName> available = Arrays.asList(new QName("ns1", "m1"), new QName("ns2", "m2"), new QName("ns3", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("ns1", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testNSnoModelNameWithAlias() {
        Import i = this.makeImport("ns1", "mymodel", null);
        List<QName> available = Arrays.asList(new QName("ns1", "m1"), new QName("ns2", "m2"), new QName("ns3", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("ns1", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testNSandUnexistentModelName() {
        Import i = this.makeImport("ns1", null, "boh");
        List<QName> available = Arrays.asList(new QName("ns1", "m1"), new QName("ns2", "m2"), new QName("ns3", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isLeft());
    }

    @Test
    public void testNSnoModelNameDefaultWithAlias2() {
        Import i = this.makeImport("ns1", "boh", null);
        List<QName> available = Arrays.asList(new QName("ns1", "m1"), new QName("ns2", "m2"), new QName("ns3", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("ns1", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testLocateInNS() {
        Import i = this.makeImport("nsA", null, "m1");
        List<QName> available = Arrays.asList(new QName("nsA", "m1"), new QName("nsA", "m2"), new QName("nsB", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("nsA", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testLocateInNSnoModelNameWithAlias() {
        Import i = this.makeImport("nsA", "m1", null);
        List<QName> available = Arrays.asList(new QName("nsA", "m1"), new QName("nsA", "m2"), new QName("nsB", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isLeft());
    }

    @Test
    public void testLocateInNSAliased() {
        Import i = this.makeImport("nsA", "aliased", "m1");
        List<QName> available = Arrays.asList(new QName("nsA", "m1"), new QName("nsA", "m2"), new QName("nsB", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new QName("nsA", "m1"), (Object)result.getOrElse(null));
    }

    @Test
    public void testLocateInNSunexistent() {
        Import i = this.makeImport("nsA", null, "boh");
        List<QName> available = Arrays.asList(new QName("nsA", "m1"), new QName("nsA", "m2"), new QName("nsB", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isLeft());
    }

    @Test
    public void testLocateInNSnoModelNameWithAlias2() {
        Import i = this.makeImport("nsA", "boh", null);
        List<QName> available = Arrays.asList(new QName("nsA", "m1"), new QName("nsA", "m2"), new QName("nsB", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isLeft());
    }

    @Test
    public void testLocateInNSAliasedBadScenario() {
        Import i = this.makeImport("nsA", "aliased", "mA");
        List<QName> available = Arrays.asList(new QName("nsA", "mA"), new QName("nsA", "mA"), new QName("nsB", "m3"));
        Either result = ImportDMNResolverUtil.resolveImportDMN((Import)i, available, Function.identity());
        Assert.assertTrue((boolean)result.isLeft());
    }

    private Import makeImport(String namespace, String name, String modelName) {
        Import i = new Import();
        i.setNamespace(namespace);
        HashMap<QName, String> addAttributes = new HashMap<QName, String>();
        if (name != null) {
            addAttributes.put(Import.NAME_QNAME, name);
        }
        if (modelName != null) {
            addAttributes.put(Import.MODELNAME_QNAME, modelName);
        }
        i.setAdditionalAttributes(addAttributes);
        return i;
    }
}

