/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.core.compiler.ItemDefinitionDependenciesSorter;
import org.kie.dmn.model.v1_1.ItemDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ItemDefinitionDependenciesGeneratedTest {
    private final Logger logger = LoggerFactory.getLogger(ItemDefinitionDependenciesGeneratedTest.class);
    private static final int NUMBER_OF_BASE_ITEM_DEFINITIONS = 5;
    private static final int LEVELS_OF_DEPENDENCIES = 3;
    private static final String ITEM_DEFINITION_NAME_BASE = "ItemDefinition";
    private static final String TEST_NS = "https://www.drools.org/";
    @Parameterized.Parameter
    public static List<ItemDefinition> itemDefinitions;

    @Parameterized.Parameters
    public static Collection<List<ItemDefinition>> generateParameters() {
        List<ItemDefinition> baseItemDefinitions = ItemDefinitionDependenciesGeneratedTest.getBaseListOfItemDefinitions(1);
        ArrayList<List<ItemDefinition>> permutations = new ArrayList<List<ItemDefinition>>();
        ItemDefinitionDependenciesGeneratedTest.getPermutations(baseItemDefinitions, new ArrayList<ItemDefinition>(), permutations);
        return ItemDefinitionDependenciesGeneratedTest.generateItemDefinitionsWithDependencies(permutations);
    }

    private static void getPermutations(List<ItemDefinition> itemDefinitions, List<ItemDefinition> head, Collection<List<ItemDefinition>> result) {
        if (itemDefinitions.size() == 1) {
            ArrayList<ItemDefinition> resultList = new ArrayList<ItemDefinition>(head);
            resultList.addAll(itemDefinitions);
            result.add(resultList);
        } else {
            for (ItemDefinition itemDefinition : itemDefinitions) {
                ArrayList<ItemDefinition> newHead = new ArrayList<ItemDefinition>(head);
                newHead.add(itemDefinition);
                List<ItemDefinition> possibleDependencies = itemDefinitions.stream().filter(item -> !newHead.contains(item)).collect(Collectors.toList());
                ItemDefinitionDependenciesGeneratedTest.getPermutations(possibleDependencies, newHead, result);
            }
        }
    }

    private static Collection<List<ItemDefinition>> generateItemDefinitionsWithDependencies(Collection<List<ItemDefinition>> itemDefinitionPermutations) {
        ArrayList<List<ItemDefinition>> result = new ArrayList<List<ItemDefinition>>();
        itemDefinitionPermutations.forEach(itemDefinitions -> {
            for (int numberOfDependencies = 1; numberOfDependencies < 5; ++numberOfDependencies) {
                for (int addDependenciesFromItemIndex = 0; addDependenciesFromItemIndex < 5; ++addDependenciesFromItemIndex) {
                    result.add(ItemDefinitionDependenciesGeneratedTest.generateItemDefinitionsWithDependencies(itemDefinitions, ItemDefinitionDependenciesGeneratedTest.getBaseListOfItemDefinitions(10), numberOfDependencies, addDependenciesFromItemIndex, 3));
                }
            }
        });
        return result;
    }

    private static List<ItemDefinition> generateItemDefinitionsWithDependencies(List<ItemDefinition> itemDefinitions, List<ItemDefinition> dependencies, int maxNumberOfDepsPerItemDefinition, int startWithItemIndex, int levelsOfDependencies) {
        ArrayList<ItemDefinition> resultTail = new ArrayList<ItemDefinition>();
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = startWithItemIndex; i < itemDefinitions.size(); ++i) {
            resultTail.add(ItemDefinitionDependenciesGeneratedTest.createItemDefinitionWithDeps(itemDefinitions.get(i), dependencies, maxNumberOfDepsPerItemDefinition, usedNames));
        }
        ArrayList<ItemDefinition> resultHead = new ArrayList<ItemDefinition>();
        for (int i = 0; i < startWithItemIndex; ++i) {
            resultHead.add(ItemDefinitionDependenciesGeneratedTest.createItemDefinitionWithDeps(itemDefinitions.get(i), dependencies, maxNumberOfDepsPerItemDefinition, usedNames));
        }
        resultHead.addAll(resultTail);
        if (levelsOfDependencies > 1) {
            resultHead.addAll(ItemDefinitionDependenciesGeneratedTest.generateItemDefinitionsWithDependencies(dependencies, ItemDefinitionDependenciesGeneratedTest.getBaseListOfItemDefinitions(levelsOfDependencies * 100), maxNumberOfDepsPerItemDefinition, startWithItemIndex, levelsOfDependencies - 1));
        } else {
            resultHead.addAll(dependencies);
        }
        return resultHead;
    }

    private static ItemDefinition createItemDefinitionWithDeps(ItemDefinition itemDefinitionTemplate, List<ItemDefinition> dependencies, int maxNumberOfDepsPerItemDefinition, Set<String> usedNames) {
        ItemDefinition it = new ItemDefinition();
        it.setName(itemDefinitionTemplate.getName());
        List<ItemDefinition> possibleDependencies = dependencies.stream().filter(item -> !item.getName().equals(it.getName())).collect(Collectors.toList());
        ItemDefinitionDependenciesGeneratedTest.addDepsToItemDefinition(it, possibleDependencies, maxNumberOfDepsPerItemDefinition, usedNames);
        return it;
    }

    private static void addDepsToItemDefinition(ItemDefinition itemDefinition, List<ItemDefinition> dependencies, int numberOfDeps, Set<String> usedNames) {
        int addedDepsCount = 0;
        for (ItemDefinition dependency : dependencies) {
            if (usedNames.contains(dependency.getName())) continue;
            ItemDefinitionDependenciesGeneratedTest.createAndAddDependency(itemDefinition, dependency);
            usedNames.add(dependency.getName());
            if (++addedDepsCount != numberOfDeps) continue;
            return;
        }
    }

    private static void createAndAddDependency(ItemDefinition itemDefinition, ItemDefinition dependency) {
        ItemDefinition newDependency = new ItemDefinition();
        newDependency.setName("_" + itemDefinition.getName() + "-" + dependency.getName());
        newDependency.setTypeRef(new QName(TEST_NS, dependency.getName()));
        itemDefinition.getItemComponent().add(newDependency);
    }

    private static List<ItemDefinition> getBaseListOfItemDefinitions(int nameIndexFrom) {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
        for (int i = nameIndexFrom; i < 5 + nameIndexFrom; ++i) {
            ItemDefinition it = new ItemDefinition();
            it.setName(ITEM_DEFINITION_NAME_BASE + i);
            itemDefinitions.add(it);
        }
        return itemDefinitions;
    }

    private List<ItemDefinition> orderingStrategy(List<ItemDefinition> ins) {
        return new ItemDefinitionDependenciesSorter(TEST_NS).sort(ins);
    }

    @Test
    public void testOrdering() {
        this.logger.trace("Item definitions:");
        itemDefinitions.forEach(itemDefinition -> {
            this.logger.trace(itemDefinition.getName());
            itemDefinition.getItemComponent().forEach(dependency -> this.logger.trace(dependency.getName()));
        });
        List<ItemDefinition> orderedList = this.orderingStrategy(itemDefinitions);
        for (ItemDefinition itemDefinition2 : itemDefinitions) {
            this.assertOrdering(itemDefinition2, orderedList);
        }
    }

    private void assertOrdering(ItemDefinition itemDefinition, List<ItemDefinition> orderedList) {
        for (ItemDefinition dependency : itemDefinition.getItemComponent()) {
            String dependencyName = dependency.getTypeRef().getLocalPart();
            int indexOfDependency = this.indexOfItemDefinitionByName(dependencyName, orderedList);
            Assert.assertTrue((String)("Cannot find dependency " + dependencyName + " in the ordered list!"), (indexOfDependency > -1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Index of " + itemDefinition.getName() + " < " + dependency.getTypeRef().getLocalPart()), (orderedList.indexOf(itemDefinition) > indexOfDependency ? 1 : 0) != 0);
            if (dependency.getItemComponent() == null || dependency.getItemComponent().isEmpty()) continue;
            this.assertOrdering(dependency, orderedList);
        }
    }

    private int indexOfItemDefinitionByName(String name, List<ItemDefinition> itemDefinitions) {
        int index = 0;
        for (ItemDefinition itemDefinition : itemDefinitions) {
            if (itemDefinition.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

