/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.marshalling.v1_1.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.compiler.ItemDefinitionDependenciesSorter;
import org.kie.dmn.model.v1_1.ItemDefinition;

public class ItemDefinitionDependenciesTest {
    private static final String TEST_NS = "https://www.drools.org/";
    private static final DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();

    private ItemDefinition build(String name, ItemDefinition ... components) {
        ItemDefinition res = new ItemDefinition();
        res.setName(name);
        for (ItemDefinition ic : components) {
            ItemDefinition c = new ItemDefinition();
            c.setName("_" + name + "-" + ic.getName());
            c.setTypeRef(new QName(TEST_NS, ic.getName()));
            res.getItemComponent().add(c);
        }
        return res;
    }

    private List<ItemDefinition> orderingStrategy(List<ItemDefinition> ins) {
        return new ItemDefinitionDependenciesSorter(TEST_NS).sort(ins);
    }

    @Test
    public void testGeneric() {
        ItemDefinition a = this.build("a", new ItemDefinition[0]);
        ItemDefinition b = this.build("b", new ItemDefinition[0]);
        ItemDefinition c = this.build("c", a, b);
        ItemDefinition d = this.build("d", c);
        List<ItemDefinition> originalList = Arrays.asList(d, c, b, a);
        List<ItemDefinition> orderedList = this.orderingStrategy(originalList);
        Assert.assertThat(orderedList.subList(0, 2), (Matcher)Matchers.containsInAnyOrder((Object[])new ItemDefinition[]{a, b}));
        Assert.assertThat(orderedList.subList(2, 4), (Matcher)Matchers.contains((Object[])new ItemDefinition[]{c, d}));
    }

    @Test
    public void testGeneric2() {
        ItemDefinition z = this.build("z", new ItemDefinition[0]);
        ItemDefinition b = this.build("b", new ItemDefinition[0]);
        ItemDefinition a = this.build("a", z);
        List<ItemDefinition> originalList = Arrays.asList(z, b, a);
        List<ItemDefinition> orderedList = this.orderingStrategy(originalList);
        Assert.assertTrue((String)"Index of z < a", (orderedList.indexOf(z) < orderedList.indexOf(a) ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering1() {
        ItemDefinition tCollateralRiskCategory = this.build("tCollateralRiskCategory", new ItemDefinition[0]);
        ItemDefinition tCreditRiskCategory = this.build("tCreditRiskCategory", new ItemDefinition[0]);
        ItemDefinition tAffordabilityCategory = this.build("tAffordabilityCategory", new ItemDefinition[0]);
        ItemDefinition tLoanRecommendation = this.build("tLoanRecommendation", new ItemDefinition[0]);
        ItemDefinition tLoan = this.build("tLoan", new ItemDefinition[0]);
        ItemDefinition tAge = this.build("tAge", new ItemDefinition[0]);
        ItemDefinition temploementStatus = this.build("temploementStatus", new ItemDefinition[0]);
        ItemDefinition tCreditScore = this.build("tCreditScore", new ItemDefinition[0]);
        ItemDefinition tRiskCategory = this.build("tRiskCategory", new ItemDefinition[0]);
        ItemDefinition tIncomeRisk = this.build("tIncomeRisk", new ItemDefinition[0]);
        ItemDefinition tBorrowe = this.build("tBorrowe", tAge, temploementStatus);
        ItemDefinition tPrequalification = this.build("tPrequalification", new ItemDefinition[0]);
        List<ItemDefinition> originalList = Arrays.asList(tCollateralRiskCategory, tCreditRiskCategory, tAffordabilityCategory, tLoanRecommendation, tLoan, tAge, temploementStatus, tCreditScore, tRiskCategory, tIncomeRisk, tBorrowe, tPrequalification);
        List<ItemDefinition> orderedList = this.orderingStrategy(originalList);
        Assert.assertTrue((String)"Index of tAge < tBorrowe", (orderedList.indexOf(tAge) < orderedList.indexOf(tBorrowe) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of temploementStatus < tBorrowe", (orderedList.indexOf(temploementStatus) < orderedList.indexOf(tBorrowe) ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering2() {
        ItemDefinition tMortgageType = this.build("tMortgageType", new ItemDefinition[0]);
        ItemDefinition tObjective = this.build("tObjective", new ItemDefinition[0]);
        ItemDefinition tRequested = this.build("tRequested", tMortgageType, tObjective);
        ItemDefinition tProduct = this.build("tProduct", new ItemDefinition[0]);
        ItemDefinition tProductCollection = this.build("tProductCollection", tProduct);
        ItemDefinition tConformanceType = this.build("tConformanceType", new ItemDefinition[0]);
        ItemDefinition tLoanTypes = this.build("tLoanTypes", tMortgageType, tConformanceType);
        List<ItemDefinition> originalList = Arrays.asList(tRequested, tProduct, tProductCollection, tMortgageType, tObjective, tConformanceType, tLoanTypes);
        List<ItemDefinition> orderedList = this.orderingStrategy(originalList);
        Assert.assertTrue((String)"Index of tMortgageType < tRequested", (orderedList.indexOf(tMortgageType) < orderedList.indexOf(tRequested) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tObjective < tRequested", (orderedList.indexOf(tObjective) < orderedList.indexOf(tRequested) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tProduct < tProductCollection", (orderedList.indexOf(tProduct) < orderedList.indexOf(tProductCollection) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tMortgageType < tLoanTypes", (orderedList.indexOf(tMortgageType) < orderedList.indexOf(tLoanTypes) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tConformanceType < tLoanTypes", (orderedList.indexOf(tConformanceType) < orderedList.indexOf(tLoanTypes) ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering3() {
        ItemDefinition tNumberList = this.build("tNumberList", new ItemDefinition[0]);
        ItemDefinition tTax = this.build("tTax", new ItemDefinition[0]);
        ItemDefinition tStateModel = this.build("tStateModel", new ItemDefinition[0]);
        ItemDefinition tTaxList = this.build("tTaxList", tTax);
        ItemDefinition tCategory = this.build("tCategory", new ItemDefinition[0]);
        ItemDefinition tItem = this.build("tItem", tCategory);
        ItemDefinition tItemList = this.build("tItemList", tItem);
        ItemDefinition tOrder = this.build("tOrder", tItemList);
        List<ItemDefinition> originalList = Arrays.asList(tOrder, tItem, tCategory, tNumberList, tItemList, tTax, tStateModel, tTaxList);
        List<ItemDefinition> orderedList = this.orderingStrategy(originalList);
        Assert.assertTrue((String)"Index of tCategory < tItem", (orderedList.indexOf(tCategory) < orderedList.indexOf(tItem) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tItem < tItemList", (orderedList.indexOf(tItem) < orderedList.indexOf(tItemList) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tItemList < tOrder", (orderedList.indexOf(tItemList) < orderedList.indexOf(tOrder) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of tTax < tTaxList", (orderedList.indexOf(tTax) < orderedList.indexOf(tTaxList) ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering4() {
        ItemDefinition _TypeDecisionA1 = this.build("TypeDecisionA1", new ItemDefinition[0]);
        ItemDefinition _TypeDecisionA2_x = this.build("TypeDecisionA2.x", _TypeDecisionA1);
        ItemDefinition _TypeDecisionA3 = this.build("TypeDecisionA3", _TypeDecisionA2_x);
        ItemDefinition _TypeDecisionB1 = this.build("TypeDecisionB1", new ItemDefinition[0]);
        ItemDefinition _TypeDecisionB2_x = this.build("TypeDecisionB2.x", _TypeDecisionB1);
        ItemDefinition _TypeDecisionB3 = this.build("TypeDecisionB3", _TypeDecisionB2_x, _TypeDecisionA3);
        ItemDefinition _TypeDecisionC1 = this.build("TypeDecisionC1", _TypeDecisionA3, _TypeDecisionB3);
        ItemDefinition _TypeDecisionC4 = this.build("TypeDecisionC4", new ItemDefinition[0]);
        List<ItemDefinition> originalList = Arrays.asList(_TypeDecisionA1, _TypeDecisionA2_x, _TypeDecisionA3, _TypeDecisionB1, _TypeDecisionB2_x, _TypeDecisionB3, _TypeDecisionC1, _TypeDecisionC4);
        List<ItemDefinition> orderedList = this.orderingStrategy(originalList);
        Assert.assertTrue((String)"Index of _TypeDecisionA1 < _TypeDecisionA2_x", (orderedList.indexOf(_TypeDecisionA1) < orderedList.indexOf(_TypeDecisionA2_x) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of _TypeDecisionA2_x < _TypeDecisionA3", (orderedList.indexOf(_TypeDecisionA2_x) < orderedList.indexOf(_TypeDecisionA3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of _TypeDecisionA3 < _TypeDecisionB3", (orderedList.indexOf(_TypeDecisionA3) < orderedList.indexOf(_TypeDecisionB3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of _TypeDecisionA3 < _TypeDecisionC1", (orderedList.indexOf(_TypeDecisionA3) < orderedList.indexOf(_TypeDecisionC1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of _TypeDecisionB1 < _TypeDecisionB2_x", (orderedList.indexOf(_TypeDecisionB1) < orderedList.indexOf(_TypeDecisionB2_x) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of _TypeDecisionB2_x < _TypeDecisionB3", (orderedList.indexOf(_TypeDecisionB2_x) < orderedList.indexOf(_TypeDecisionB3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Index of _TypeDecisionB3 < _TypeDecisionC1", (orderedList.indexOf(_TypeDecisionB3) < orderedList.indexOf(_TypeDecisionC1) ? 1 : 0) != 0);
    }
}

