/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.extensions;

import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.extensions.FirstNameDescription;
import org.kie.dmn.core.compiler.extensions.FirstNameLastNameProfile;
import org.kie.dmn.core.compiler.extensions.LastNameDescription;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.InputData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNExtensionRegisterTest {
    private static final Logger LOG = LoggerFactory.getLogger(DMNExtensionRegisterTest.class);

    @Test
    public void testUsingSystemProperty() {
        try {
            System.setProperty("org.kie.dmn.profiles.FirstNameLastNameProfile", FirstNameLastNameProfile.class.getCanonicalName());
            Assert.assertEquals((Object)FirstNameLastNameProfile.class.getCanonicalName(), (Object)System.getProperty("org.kie.dmn.profiles.FirstNameLastNameProfile"));
            DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0001-input-data-string-with-extensions.dmn", this.getClass());
            DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
            Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)this.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertEquals((long)3L, (long)dmnModel.getDefinitions().getDrgElement().size());
            InputData inputData1 = (InputData)dmnModel.getDefinitions().getDrgElement().get(1);
            Assert.assertEquals((Object)"First Name", (Object)inputData1.getName());
            DMNElement.ExtensionElements id1elements = inputData1.getExtensionElements();
            Assert.assertTrue((id1elements != null ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)id1elements.getAny().size());
            FirstNameDescription firstNameDescription = (FirstNameDescription)id1elements.getAny().get(0);
            Assert.assertTrue((boolean)firstNameDescription.getContent().equals("First name in latin characters"));
            InputData inputData2 = (InputData)dmnModel.getDefinitions().getDrgElement().get(2);
            Assert.assertEquals((Object)"Last Name", (Object)inputData2.getName());
            DMNElement.ExtensionElements id2elements = inputData2.getExtensionElements();
            Assert.assertTrue((id2elements != null ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)id2elements.getAny().size());
            LastNameDescription lastNameDescription = (LastNameDescription)id2elements.getAny().get(0);
            Assert.assertTrue((boolean)lastNameDescription.getContent().equals("Last name in latin characters"));
        }
        catch (Exception e) {
            LOG.error("{}", (Object)e.getLocalizedMessage(), (Object)e);
            throw e;
        }
        finally {
            System.clearProperty("org.kie.dmn.profiles.FirstNameLastNameProfile");
            Assert.assertNull((Object)System.getProperty("org.kie.dmn.profiles.FirstNameLastNameProfile"));
        }
    }

    @Test
    public void testUsingKModuleProperty() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.FirstNameLastNameProfile", FirstNameLastNameProfile.class.getCanonicalName());
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource("0001-input-data-string-with-extensions.dmn", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() == 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)this.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((long)3L, (long)dmnModel.getDefinitions().getDrgElement().size());
        InputData inputData1 = (InputData)dmnModel.getDefinitions().getDrgElement().get(1);
        Assert.assertEquals((Object)"First Name", (Object)inputData1.getName());
        DMNElement.ExtensionElements id1elements = inputData1.getExtensionElements();
        Assert.assertTrue((id1elements != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)id1elements.getAny().size());
        FirstNameDescription firstNameDescription = (FirstNameDescription)id1elements.getAny().get(0);
        Assert.assertTrue((boolean)firstNameDescription.getContent().equals("First name in latin characters"));
        InputData inputData2 = (InputData)dmnModel.getDefinitions().getDrgElement().get(2);
        Assert.assertEquals((Object)"Last Name", (Object)inputData2.getName());
        DMNElement.ExtensionElements id2elements = inputData2.getExtensionElements();
        Assert.assertTrue((id2elements != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)id2elements.getAny().size());
        LastNameDescription lastNameDescription = (LastNameDescription)id2elements.getAny().get(0);
        Assert.assertTrue((boolean)lastNameDescription.getContent().equals("Last name in latin characters"));
    }

    @Test
    public void testUsingKModuleProperty_WrongClasses() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.FirstNameLastNameProfile", "foo");
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource("0001-input-data-string-with-extensions.dmn", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() > 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)this.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((long)3L, (long)dmnModel.getDefinitions().getDrgElement().size());
        InputData inputData1 = (InputData)dmnModel.getDefinitions().getDrgElement().get(1);
        Assert.assertEquals((Object)"First Name", (Object)inputData1.getName());
        DMNElement.ExtensionElements id1elements = inputData1.getExtensionElements();
        Assert.assertTrue((id1elements != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)id1elements.getAny().size());
        InputData inputData2 = (InputData)dmnModel.getDefinitions().getDrgElement().get(2);
        Assert.assertEquals((Object)"Last Name", (Object)inputData2.getName());
        DMNElement.ExtensionElements id2elements = inputData2.getExtensionElements();
        Assert.assertTrue((id2elements != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)id2elements.getAny().size());
    }

    private String formatMessages(List<DMNMessage> messages) {
        return messages.stream().map(m -> m.toString()).collect(Collectors.joining("\n"));
    }
}

