/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.decisionservices;

import java.math.BigDecimal;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDecisionServicesTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNDecisionServicesTest.class);

    @Test
    public void testBasic() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("0004-decision-services.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        this.checkDSwithInputData(runtime, dmnModel);
        this.checkDSwithInputDecision(runtime, dmnModel);
        this.checkDSwithInputDecision2(runtime, dmnModel);
    }

    private void checkDSwithInputData(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "A only as output knowing D and E");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("A"), (Matcher)CoreMatchers.is((Object)"de"));
    }

    private void checkDSwithInputDecision(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "A Only Knowing B and C");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("A"), (Matcher)CoreMatchers.nullValue());
    }

    private void checkDSwithInputDecision2(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        context.set("B", (Object)"inB");
        context.set("C", (Object)"inC");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "A Only Knowing B and C");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("A"), (Matcher)CoreMatchers.is((Object)"inBinC"));
    }

    @Test
    public void testDSInLiteralExpression() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionServicesInLiteralExpression.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"xyde"));
    }

    @Test
    public void testDSInLiteralExpressionWithBKM() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionServicesInLiteralExpressionWithBKM.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"xydemn"));
    }

    @Test
    public void testDSInLiteralExpressionWithBKMUsingInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionServicesInLiteralExpressionWithBKMUsingInvocation.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"xydemn"));
    }

    @Test
    public void testDSInLiteralExpressionOnlyfromBKMUsingInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionServicesInLiteralExpressionOnlyFromBKMUsingInvocation.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"demn"));
    }

    @Test
    public void testMixtypeDS() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("mixtype-DS.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_c9885563-aa54-4c7b-ae8a-738cfd29b544", "mixtype DS");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person year of birth", (Object)BigDecimal.valueOf(1980L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        Assert.assertThat((Object)result.get("Person age"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(38L)));
        Assert.assertThat((Object)result.get("is Person an adult"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, ds all")));
        Assert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(18L))));
        Assert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)true)));
        Assert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, DS encapsulate")));
        Assert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)true)));
        Assert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, DS greet adult")));
        Assert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)true)));
        Assert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
        this.testMixtypeDS_checkDSall(runtime, dmnModel);
        this.testMixtypeDS_checkDSencapsulate(runtime, dmnModel);
        this.testMixtypeDS_checkDSgreetadult(runtime, dmnModel);
    }

    private void testMixtypeDS_checkDSall(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person year of birth", (Object)BigDecimal.valueOf(2008L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS all");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John")));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(10L))));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)false)));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
    }

    private void testMixtypeDS_checkDSencapsulate(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person year of birth", (Object)BigDecimal.valueOf(2008L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS encapsulate");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John")));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)false)));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
    }

    private void testMixtypeDS_checkDSgreetadult(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person age", (Object)BigDecimal.valueOf(10L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS greet adult");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John")));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Person age"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)false)));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
    }

    @Test
    public void testDSForTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("DecisionService20180718.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_6eef3a7c-bb0d-40bb-858d-f9067789c18a", "Decision Service 20180718");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        this.testDSForTypeCheck_runNormal(runtime, dmnModel);
        this.testDSForTypeCheck_runAllDecisionsWithWrongTypes(runtime, dmnModel);
        this.testDSForTypeCheck_runDecisionService_Normal(runtime, dmnModel);
        this.testDSForTypeCheck_runDecisionService_WithWrongTypes(runtime, dmnModel);
    }

    private void testDSForTypeCheck_runNormal(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person age", (Object)BigDecimal.valueOf(21L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greet the person"), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        Assert.assertThat((Object)result.get("is Person at age allowed"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.get("Final Decision"), (Matcher)CoreMatchers.is((Object)"Hello, John; you are allowed"));
    }

    private void testDSForTypeCheck_runAllDecisionsWithWrongTypes(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)BigDecimal.valueOf(21L));
        context.set("Person age", (Object)"John");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void testDSForTypeCheck_runDecisionService_Normal(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person age", (Object)BigDecimal.valueOf(21L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS given inputdata");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the person"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person at age allowed"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)result.get("Final Decision"), (Matcher)CoreMatchers.is((Object)"Hello, John; you are allowed"));
    }

    private void testDSForTypeCheck_runDecisionService_WithWrongTypes(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)BigDecimal.valueOf(21L));
        context.set("Person age", (Object)"John");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS given inputdata");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDSSingletonOrMultipleOutputDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Decision-Services-singleton-or-multiple-output-decisions.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b4ebfbf2-8608-4297-9662-be70bab01974", "Decision Services singleton or multiple output decisions");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
        Assert.assertThat((Object)result.get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
        Assert.assertThat((Object)result.get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
        Assert.assertThat((Object)result.get("eval DS with singleton value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
        Assert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value")));
        Assert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L))));
        DMNResult dmnResultDSSingleton = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with singleton value");
        LOG.debug("{}", (Object)dmnResultDSSingleton);
        dmnResultDSSingleton.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResultDSSingleton.getMessages()), (Object)dmnResultDSSingleton.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResultDSSingleton.getContext().get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
        Assert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)Matchers.anything())));
        DMNResult dmnResultMultiple = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with multiple output decisions");
        LOG.debug("{}", (Object)dmnResultMultiple);
        dmnResultMultiple.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResultMultiple.getMessages()), (Object)dmnResultMultiple.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResultMultiple.getContext().get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
        Assert.assertThat((Object)dmnResultMultiple.getContext().get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
        Assert.assertThat((Object)dmnResultMultiple.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Value"), (Matcher)Matchers.anything())));
    }

    @Test
    public void testDSSingletonOrMultipleOutputDecisions_OVERRIDE() {
        try {
            System.setProperty("org.kie.dmn.decisionservice.coercesingleton", "false");
            DMNRuntime runtime = DMNRuntimeUtil.createRuntime("Decision-Services-singleton-or-multiple-output-decisions.dmn", this.getClass());
            DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b4ebfbf2-8608-4297-9662-be70bab01974", "Decision Services singleton or multiple output decisions");
            Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            DMNContext emptyContext = DMNFactory.newContext();
            DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
            LOG.debug("{}", (Object)dmnResult);
            dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
            Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            DMNContext result = dmnResult.getContext();
            Assert.assertThat((Object)result.get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
            Assert.assertThat((Object)result.get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
            Assert.assertThat((Object)result.get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
            Assert.assertThat((Object)((Map)result.get("eval DS with singleton value")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Value"), (Matcher)CoreMatchers.is((Object)"a string Value")));
            Assert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value")));
            Assert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L))));
            DMNResult dmnResultDSSingleton = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with singleton value");
            LOG.debug("{}", (Object)dmnResultDSSingleton);
            dmnResultDSSingleton.getDecisionResults().forEach(x -> LOG.debug("{}", x));
            Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResultDSSingleton.getMessages()), (Object)dmnResultDSSingleton.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)dmnResultDSSingleton.getContext().get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
            Assert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)Matchers.anything())));
            Assert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)Matchers.anything())));
            DMNResult dmnResultMultiple = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with multiple output decisions");
            LOG.debug("{}", (Object)dmnResultMultiple);
            dmnResultMultiple.getDecisionResults().forEach(x -> LOG.debug("{}", x));
            Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnResultMultiple.getMessages()), (Object)dmnResultMultiple.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)dmnResultMultiple.getContext().get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
            Assert.assertThat((Object)dmnResultMultiple.getContext().get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
            Assert.assertThat((Object)dmnResultMultiple.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Value"), (Matcher)Matchers.anything())));
        }
        catch (Exception e) {
            LOG.error("{}", (Object)e.getLocalizedMessage(), (Object)e);
            throw e;
        }
        finally {
            System.clearProperty("org.kie.dmn.decisionservice.coercesingleton");
            Assert.assertNull((Object)System.getProperty("org.kie.dmn.decisionservice.coercesingleton"));
        }
    }
}

