/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.imports;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsTest {
    public static final Logger LOG = LoggerFactory.getLogger(ImportsTest.class);

    @Test
    public void testImportDependenciesForDTInAContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Imported_Model.dmn", this.getClass(), "Import_BKM_and_have_a_Decision_Ctx_with_DT.dmn");
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/definitions/_f27bb64b-6fc7-4e1f-9848-11ba35e0df36", "Imported Model");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c3e08836-7973-4e4d-af2b-d46b23725c13", "Import BKM and have a Decision Ctx with DT");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("A Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("name", "John"), DynamicTypeUtils.entry("age", 47)));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("A Decision Ctx with DT").getResult(), (Matcher)CoreMatchers.is((Object)"Respectfully, Hello John!"));
    }

    @Test
    public void testImport2BKMs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Do_say_hello_with_2_bkms.dmn", this.getClass(), "Saying_hello_2_bkms.dmn");
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_01a65215-7e0d-47ac-845a-a768f6abf7fe", "Do say hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Person name", (Object)"John");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Say hello decision").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("what about hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello"));
    }

    @Test
    public void testImport2BKMsInvoke() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Do_invoke_hello_with_2_bkms.dmn", this.getClass(), "Saying_hello_2_bkms.dmn");
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_eedf6ecc-f113-4333-ace0-79b783e313e5", "Do invoke hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = runtime.newContext();
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("invocation of hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
    }

    @Test
    public void testImport2BKMsInvokeUsingInputData() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Do_invoke_hello_with_2_bkms_using_inputdata.dmn", this.getClass(), "Saying_hello_2_bkms.dmn");
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_eedf6ecc-f113-4333-ace0-79b783e313e5", "Do invoke hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Person name", (Object)"Bob");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("what about hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, Bob"));
    }

    @Test
    public void testImport3Levels() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("L3_Do_say_hello.dmn", this.getClass(), "Do_say_hello_with_2_bkms.dmn", "Saying_hello_2_bkms.dmn");
        if (LOG.isDebugEnabled()) {
            runtime.addListener(DMNRuntimeUtil.createListener());
        }
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_01a65215-7e0d-47ac-845a-a768f6abf7fe", "Do say hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModelL3 = runtime.getModel("http://www.trisotech.com/dmn/definitions/_820c548c-377d-463e-a62b-bb95ddc4758c", "L3 Do say hello");
        Assert.assertThat((Object)dmnModelL3, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModelL3.getMessages()), (Object)dmnModelL3.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Another Name", (Object)"Bob");
        context.set("L2import", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Person name", "John")));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModelL3, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("L3 decision").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, Bob"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("L3 view on M2").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("L3 what about hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello"));
    }

    @Test
    public void testImportHardcodedDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources("Spell_Greeting.dmn", this.getClass(), "Import_Spell_Greeting.dmn");
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_88f4fc88-1eb2-4188-a721-5720cf5565ce", "Spell Greeting");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_d67f19e9-7835-4cad-9c80-16b8423cc392", "Import Spell Greeting");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Person Name", (Object)"John");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages(evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Say the Greeting to Person").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
    }
}

