/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.AfterEvaluateBKMEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateBKMEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.api.event.DefaultDMNRuntimeEventListener;
import org.kie.dmn.core.compiler.DMNOption;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.KieHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DMNRuntimeUtil {
    public static final Logger LOG = LoggerFactory.getLogger(DMNRuntimeUtil.class);

    public static DMNRuntime createRuntime(Class testClass) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[0]);
        DMNRuntime runtime = DMNRuntimeUtil.typeSafeGetKieRuntime(kieContainer);
        Assert.assertNotNull((Object)runtime);
        return runtime;
    }

    public static DMNRuntime createRuntime(String resourceName, Class testClass) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource(resourceName, testClass)});
        DMNRuntime runtime = DMNRuntimeUtil.typeSafeGetKieRuntime(kieContainer);
        Assert.assertNotNull((Object)runtime);
        return runtime;
    }

    public static DMNRuntime createRuntimeWithAdditionalResources(String resourceName, Class testClass, String ... additionalResources) {
        KieServices ks = KieServices.Factory.get();
        Resource mainResource = ks.getResources().newClassPathResource(resourceName, testClass);
        ArrayList<Resource> totalResources = new ArrayList<Resource>();
        totalResources.add(mainResource);
        for (String add : additionalResources) {
            totalResources.add(ks.getResources().newClassPathResource(add, testClass));
        }
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])totalResources.toArray(new Resource[0]));
        DMNRuntime runtime = DMNRuntimeUtil.typeSafeGetKieRuntime(kieContainer);
        Assert.assertNotNull((Object)runtime);
        return runtime;
    }

    private static DMNRuntime typeSafeGetKieRuntime(KieContainer kieContainer) {
        DMNRuntime dmnRuntime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        ((DMNRuntimeImpl)dmnRuntime).setOption((DMNOption)new RuntimeTypeCheckOption(true));
        return dmnRuntime;
    }

    public static DMNRuntimeEventListener createListener() {
        return new DefaultDMNRuntimeEventListener(){
            private final Logger logger = LoggerFactory.getLogger(DMNRuntimeEventListener.class);

            public void beforeEvaluateDecision(BeforeEvaluateDecisionEvent event) {
                this.logger.info(event.toString());
            }

            public void afterEvaluateDecision(AfterEvaluateDecisionEvent event) {
                this.logger.info(event.toString());
            }

            public void beforeEvaluateBKM(BeforeEvaluateBKMEvent event) {
                this.logger.info(event.toString());
            }

            public void afterEvaluateBKM(AfterEvaluateBKMEvent event) {
                this.logger.info(event.toString());
            }

            public void beforeEvaluateDecisionTable(BeforeEvaluateDecisionTableEvent event) {
                this.logger.info(event.toString());
            }

            public void afterEvaluateDecisionTable(AfterEvaluateDecisionTableEvent event) {
                this.logger.info(event.toString());
            }
        };
    }

    public static String formatMessages(List<DMNMessage> messages) {
        return messages.stream().map(Object::toString).peek(m -> LOG.debug(m)).collect(Collectors.joining("\n"));
    }

    private DMNRuntimeUtil() {
    }
}

