/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.assembler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.core.assembler.DMNResource;

public class DMNResourceDependenciesSorter {
    public static List<DMNResource> sort(List<DMNResource> ins) {
        ArrayList<DMNResource> visited = new ArrayList<DMNResource>(ins.size());
        ArrayList<DMNResource> dfv = new ArrayList<DMNResource>(ins.size());
        for (DMNResource node : ins) {
            if (visited.contains(node)) continue;
            DMNResourceDependenciesSorter.dfVisit(node, ins, visited, dfv);
        }
        return dfv;
    }

    private static void dfVisit(DMNResource node, List<DMNResource> allNodes, Collection<DMNResource> visited, List<DMNResource> dfv) {
        if (visited.contains(node)) {
            throw new RuntimeException("Circular dependency detected: " + visited + " , and again to: " + node);
        }
        visited.add(node);
        List neighbours = node.getDependencies().stream().flatMap(dep -> allNodes.stream().filter(r -> r.getModelID().equals(dep))).collect(Collectors.toList());
        for (DMNResource n : neighbours) {
            if (visited.contains(n)) continue;
            DMNResourceDependenciesSorter.dfVisit(n, allNodes, visited, dfv);
        }
        dfv.add(node);
    }
}

