/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class DMNTypeRegistry {
    private Map<String, Map<String, DMNType>> types = new HashMap<String, Map<String, DMNType>>();
    public static final DMNType UNKNOWN = new SimpleTypeImpl("http://www.omg.org/spec/FEEL/20140401", BuiltInType.UNKNOWN.getName(), null, true, null, null, (Type)BuiltInType.UNKNOWN);

    public DMNTypeRegistry() {
        String feelNamespace = "http://www.omg.org/spec/FEEL/20140401";
        HashMap<String, DMNType> feelTypes = new HashMap<String, DMNType>();
        this.types.put(feelNamespace, feelTypes);
        feelTypes.put(UNKNOWN.getName(), UNKNOWN);
        for (BuiltInType type : BuiltInType.values()) {
            for (String name : type.getNames()) {
                if (type == BuiltInType.UNKNOWN) continue;
                BaseDMNTypeImpl feelPrimitiveType = type == BuiltInType.LIST ? new SimpleTypeImpl(feelNamespace, name, null, false, null, UNKNOWN, (Type)type) : (type == BuiltInType.CONTEXT ? new CompositeTypeImpl(feelNamespace, name, null, false, Collections.emptyMap(), null, (Type)type) : new SimpleTypeImpl(feelNamespace, name, null, false, null, null, (Type)type));
                feelTypes.put(name, feelPrimitiveType);
            }
        }
    }

    public DMNType registerType(DMNType type) {
        if (type.getNamespace() == null && type.getName() == null) {
            throw new IllegalArgumentException("Unknown namespace or name. Unable to register type " + type);
        }
        Map<String, DMNType> typesMap = this.types.get(type.getNamespace());
        if (typesMap == null) {
            typesMap = new HashMap<String, DMNType>();
            this.types.put(type.getNamespace(), typesMap);
        }
        if (typesMap.containsKey(type.getName())) {
            return typesMap.get(type.getName());
        }
        typesMap.put(type.getName(), type);
        return type;
    }

    public DMNType resolveType(String namespace, String name) {
        Map<String, DMNType> typeMap = this.types.get(namespace);
        if (typeMap != null) {
            return typeMap.get(name);
        }
        return null;
    }
}

