/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.util.Msg;

public class IfExpressionNode
extends BaseNode {
    private BaseNode condition;
    private BaseNode thenExpression;
    private BaseNode elseExpression;

    public IfExpressionNode(ParserRuleContext ctx, BaseNode condition, BaseNode thenExpression, BaseNode elseExpression) {
        super(ctx);
        this.condition = condition;
        this.thenExpression = thenExpression;
        this.elseExpression = elseExpression;
    }

    public BaseNode getCondition() {
        return this.condition;
    }

    public void setCondition(BaseNode condition) {
        this.condition = condition;
    }

    public BaseNode getThenExpression() {
        return this.thenExpression;
    }

    public void setThenExpression(BaseNode thenExpression) {
        this.thenExpression = thenExpression;
    }

    public BaseNode getElseExpression() {
        return this.elseExpression;
    }

    public void setElseExpression(BaseNode elseExpression) {
        this.elseExpression = elseExpression;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        Object cond = this.condition.evaluate(ctx);
        if (cond instanceof Boolean) {
            if (((Boolean)cond).booleanValue()) {
                return this.thenExpression.evaluate(ctx);
            }
            return this.elseExpression.evaluate(ctx);
        }
        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.CONDITION_WAS_NOT_A_BOOLEAN)));
        return null;
    }
}

