/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.IterationContextNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.util.Msg;

public class QuantifiedExpressionNode
extends BaseNode {
    private Quantifier quantifier;
    private List<IterationContextNode> iterationContexts;
    private BaseNode expression;

    public QuantifiedExpressionNode(ParserRuleContext ctx, Quantifier quantifier, ListNode list, BaseNode expression) {
        super(ctx);
        this.quantifier = quantifier;
        this.iterationContexts = new ArrayList<IterationContextNode>();
        this.expression = expression;
        for (BaseNode n : list.getElements()) {
            this.iterationContexts.add((IterationContextNode)n);
        }
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public void setQuantifier(Quantifier quantifier) {
        this.quantifier = quantifier;
    }

    public List<IterationContextNode> getIterationContexts() {
        return this.iterationContexts;
    }

    public void setIterationContexts(List<IterationContextNode> iterationContexts) {
        this.iterationContexts = iterationContexts;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    public void setExpression(BaseNode expression) {
        this.expression = expression;
    }

    @Override
    public Boolean evaluate(EvaluationContext ctx) {
        if (this.quantifier == Quantifier.SOME || this.quantifier == Quantifier.EVERY) {
            return this.iterateContexts(ctx, this.iterationContexts, this.expression, this.quantifier);
        }
        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.IS_NULL, "Quantifier")));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean iterateContexts(EvaluationContext ctx, List<IterationContextNode> iterationContexts, BaseNode expression, Quantifier quantifier) {
        try {
            ctx.enterFrame();
            QEIteration[] ictx = this.initializeContexts(ctx, iterationContexts);
            while (this.nextIteration(ctx, ictx)) {
                Boolean result = (Boolean)expression.evaluate(ctx);
                if (result == null || !result.equals(quantifier.positiveTest())) continue;
                Boolean bl = quantifier.positiveTest();
                return bl;
            }
            Boolean bl = quantifier.defaultValue();
            return bl;
        }
        finally {
            ctx.exitFrame();
        }
    }

    private boolean nextIteration(EvaluationContext ctx, QEIteration[] ictx) {
        int i = ictx.length - 1;
        while (i >= 0 && i < ictx.length) {
            if (ictx[i].hasNextValue()) {
                this.setValueIntoContext(ctx, ictx[i]);
                ++i;
                continue;
            }
            --i;
        }
        return i >= 0;
    }

    private void setValueIntoContext(EvaluationContext ctx, QEIteration qeIteration) {
        ctx.setValue(qeIteration.getName(), qeIteration.getNextValue());
    }

    private QEIteration[] initializeContexts(EvaluationContext ctx, List<IterationContextNode> iterationContexts) {
        QEIteration[] ictx = new QEIteration[iterationContexts.size()];
        int i = 0;
        for (IterationContextNode icn : iterationContexts) {
            ictx[i++] = this.createQuantifiedExpressionIterationContext(ctx, icn);
        }
        return ictx;
    }

    private QEIteration createQuantifiedExpressionIterationContext(EvaluationContext ctx, IterationContextNode icn) {
        String name = icn.evaluateName(ctx);
        Object result = icn.evaluate(ctx);
        List<Object> values = result instanceof Iterable ? (List<Object>)result : Collections.singletonList(result);
        QEIteration qei = new QEIteration(name, values);
        return qei;
    }

    private static class QEIteration {
        private String name;
        private Iterable values;
        private Iterator iterator;

        public QEIteration(String name, Iterable values) {
            this.name = name;
            this.values = values;
        }

        public boolean hasNextValue() {
            boolean hasValue;
            if (this.iterator == null) {
                this.iterator = this.values.iterator();
            }
            if (!(hasValue = this.iterator.hasNext())) {
                this.iterator = null;
            }
            return hasValue;
        }

        public Object getNextValue() {
            return this.iterator != null ? this.iterator.next() : null;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Quantifier {
        SOME,
        EVERY;


        public static Quantifier resolve(String text) {
            if ("some".equals(text)) {
                return SOME;
            }
            return EVERY;
        }

        public Boolean positiveTest() {
            return this == SOME;
        }

        public Boolean defaultValue() {
            return this == EVERY;
        }
    }
}

