/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.kie.dmn.feel.lang.CustomType;
import org.kie.dmn.feel.lang.Property;
import org.kie.dmn.feel.lang.Scope;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.JavaBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.ScopeImpl;
import org.kie.dmn.feel.lang.types.SymbolTable;
import org.kie.dmn.feel.lang.types.VariableSymbol;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserHelper {
    public static final Logger LOG = LoggerFactory.getLogger(ParserHelper.class);
    private SymbolTable symbols = new SymbolTable();
    private Scope currentScope = this.symbols.getGlobalScope();
    private Stack<String> currentName = new Stack();

    public ParserHelper() {
        this.currentName.push("<local>");
    }

    public SymbolTable getSymbolTable() {
        return this.symbols;
    }

    public void pushScope() {
        LOG.trace("pushScope()");
        this.currentScope = new ScopeImpl(this.currentName.peek(), this.currentScope);
    }

    public void popScope() {
        LOG.trace("popScope()");
        this.currentScope = this.currentScope.getParentScope();
    }

    public void pushName(String name) {
        LOG.trace("pushName() {}", (Object)name);
        this.currentName.push(name);
    }

    public void pushName(ParserRuleContext ctx) {
        this.currentName.push(this.getOriginalText(ctx));
    }

    public void popName() {
        LOG.trace("popName()");
        this.currentName.pop();
    }

    public void recoverScope() {
        this.recoverScope(this.currentName.peek());
    }

    public void recoverScope(String name) {
        LOG.trace("[{}] recoverScope( name: {}) with currentScope: {}", new Object[]{this.currentScope.getName(), name, this.currentScope});
        Scope s = this.currentScope.getChildScopes().get(name);
        if (s != null) {
            this.currentScope = s;
        } else {
            Symbol resolved = this.currentScope.resolve(name);
            if (resolved != null && resolved.getType() instanceof CustomType) {
                this.pushName(name);
                this.pushScope();
                CustomType type = (CustomType)resolved.getType();
                for (Property f : type.getProperties().values()) {
                    this.currentScope.define(new VariableSymbol(f.getName(), f.getType()));
                }
                LOG.trace(".. PUSHED, scope name {} with symbols {}", (Object)this.currentName.peek(), this.currentScope.getSymbols());
            } else {
                this.pushScope();
            }
        }
    }

    public void dismissScope() {
        LOG.trace("dismissScope()");
        this.popScope();
    }

    public void defineVariable(ParserRuleContext ctx) {
        this.defineVariable(this.getOriginalText(ctx));
    }

    public void defineVariable(String variable) {
        VariableSymbol var = new VariableSymbol(variable);
        this.currentScope.define(var);
    }

    public void defineVariable(String variable, Type type) {
        LOG.trace("defining custom type symbol.");
        VariableSymbol var = new VariableSymbol(variable, type);
        this.currentScope.define(var);
    }

    public void startVariable(Token t) {
        this.currentScope.start(t.getText());
    }

    public boolean followUp(Token t, boolean isPredict) {
        boolean follow = this.currentScope.followUp(t.getText(), isPredict);
        return follow;
    }

    public String getOriginalText(ParserRuleContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.getStart().getInputStream().getText(interval);
    }

    public static List<Token> getAllTokens(ParseTree ctx, List<Token> tokens) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree child = ctx.getChild(i);
            if (child instanceof TerminalNode) {
                tokens.add(((TerminalNode)child).getSymbol());
                continue;
            }
            ParserHelper.getAllTokens(child, tokens);
        }
        return tokens;
    }

    public static Type determineTypeFromClass(Class<?> clazz) {
        if (clazz == null) {
            return BuiltInType.UNKNOWN;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return BuiltInType.NUMBER;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return BuiltInType.STRING;
        }
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return BuiltInType.DATE;
        }
        if (LocalTime.class.isAssignableFrom(clazz) || OffsetTime.class.isAssignableFrom(clazz)) {
            return BuiltInType.TIME;
        }
        if (ZonedDateTime.class.isAssignableFrom(clazz) || OffsetDateTime.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz)) {
            return BuiltInType.DATE_TIME;
        }
        if (Duration.class.isAssignableFrom(clazz) || Period.class.isAssignableFrom(clazz)) {
            return BuiltInType.DURATION;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BuiltInType.BOOLEAN;
        }
        if (UnaryTest.class.isAssignableFrom(clazz)) {
            return BuiltInType.UNARY_TEST;
        }
        if (Range.class.isAssignableFrom(clazz)) {
            return BuiltInType.RANGE;
        }
        if (FEELFunction.class.isAssignableFrom(clazz)) {
            return BuiltInType.FUNCTION;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return BuiltInType.LIST;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return BuiltInType.CONTEXT;
        }
        return JavaBackedType.of(clazz);
    }
}

