/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Collections;
import java.util.List;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTInvokerFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(DTInvokerFunction.class);
    private final DecisionTableImpl dt;

    public DTInvokerFunction(DecisionTableImpl dt) {
        super(dt.getName());
        this.dt = dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FEELFnResult<Object> invoke(EvaluationContext ctx, Object[] params) {
        FEELEventBase capturedException = null;
        try {
            ctx.enterFrame();
            for (int i = 0; i < params.length; ++i) {
                ctx.setValue(this.dt.getParameterNames().get(i), params[i]);
            }
            Object result = this.dt.evaluate(ctx, params);
            FEELFnResult<Object> fEELFnResult = FEELFnResult.ofResult(result);
            return fEELFnResult;
        }
        catch (Exception e) {
            capturedException = new FEELEventBase(FEELEvent.Severity.ERROR, "Error invoking decision table '" + this.getName() + "'.", e);
        }
        finally {
            ctx.exitFrame();
        }
        return FEELFnResult.ofError(capturedException);
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public DecisionTableImpl getDecisionTable() {
        return this.dt;
    }

    @Override
    public List<List<String>> getParameterNames() {
        return Collections.singletonList(this.dt.getParameterNames());
    }
}

