/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.function.Supplier;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.events.ASTEventBase;
import org.kie.dmn.feel.util.Msg;

public class BaseNode
implements ASTNode {
    private int startChar;
    private int endChar;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;
    private String text;

    public BaseNode() {
    }

    public BaseNode(ParserRuleContext ctx) {
        this.setStartChar(ctx.getStart().getStartIndex());
        this.setStartLine(ctx.getStart().getLine());
        this.setStartColumn(ctx.getStart().getCharPositionInLine());
        this.setEndChar(ctx.getStop().getStopIndex());
        this.setEndLine(ctx.getStop().getLine());
        this.setEndColumn(ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length());
        this.setText(this.getOriginalText(ctx));
    }

    @Override
    public int getStartChar() {
        return this.startChar;
    }

    public void setStartChar(int startChar) {
        this.startChar = startChar;
    }

    @Override
    public int getEndChar() {
        return this.endChar;
    }

    public void setEndChar(int endChar) {
        this.endChar = endChar;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    @Override
    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.text + "}";
    }

    @Override
    public Type getResultType() {
        return BuiltInType.UNKNOWN;
    }

    protected Supplier<FEELEvent> astEvent(FEELEvent.Severity severity, String message) {
        return () -> new ASTEventBase(severity, message, this);
    }

    protected Supplier<FEELEvent> astEvent(FEELEvent.Severity severity, String message, Throwable throwable) {
        return () -> new ASTEventBase(severity, message, this, throwable);
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.BASE_NODE_EVALUATE_CALLED)));
        return null;
    }

    private String getOriginalText(ParserRuleContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.getStart().getInputStream().getText(interval);
    }
}

