/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.decisiontables;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.decisiontables.SingleValueOrContextCollector;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesSelectedEvent;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;
import org.kie.dmn.feel.util.Pair;

public enum HitPolicy {
    UNIQUE("U", "UNIQUE", HitPolicy::unique),
    FIRST("F", "FIRST", HitPolicy::first),
    PRIORITY("P", "PRIORITY", HitPolicy::priority),
    ANY("A", "ANY", HitPolicy::any),
    COLLECT("C", "COLLECT", HitPolicy::ruleOrder),
    COLLECT_SUM("C+", "COLLECT SUM", HitPolicy::sumCollect),
    COLLECT_COUNT("C#", "COLLECT COUNT", HitPolicy::countCollect),
    COLLECT_MIN("C<", "COLLECT MIN", HitPolicy::minCollect),
    COLLECT_MAX("C>", "COLLECT MAX", HitPolicy::maxCollect),
    RULE_ORDER("R", "RULE ORDER", HitPolicy::ruleOrder),
    OUTPUT_ORDER("O", "OUTPUT ORDER", HitPolicy::outputOrder);

    private final String shortName;
    private final String longName;
    private final HitPolicyDTI dti;

    private HitPolicy(String shortName, String longName) {
        this(shortName, longName, HitPolicy::notImplemented);
    }

    private HitPolicy(String shortName, String longName, HitPolicyDTI dti) {
        this.shortName = shortName;
        this.longName = longName;
        this.dti = dti;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public HitPolicyDTI getDti() {
        return this.dti;
    }

    public static HitPolicy fromString(String policy) {
        policy = policy.toUpperCase();
        for (HitPolicy c : HitPolicy.values()) {
            if (!c.shortName.equals(policy) && !c.longName.equals(policy)) continue;
            return c;
        }
        throw new IllegalArgumentException("Unknown hit policy: " + policy);
    }

    public static Object notImplemented(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        throw new RuntimeException("Not implemented");
    }

    public static Object unique(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        if (matches.size() > 1) {
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                List<Integer> ruleMatches = matches.stream().map(m -> m.getIndex() + 1).collect(Collectors.toList());
                return new HitPolicyViolationEvent(FEELEvent.Severity.ERROR, "UNIQUE hit policy decision tables can only have one matching rule. Multiple matches found for decision table '" + dt.getName() + "'. Matched rules: " + ruleMatches, dt.getName(), ruleMatches);
            });
            return null;
        }
        if (matches.size() == 1) {
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                int index = ((DTDecisionRule)matches.get(0)).getIndex() + 1;
                return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rule fired for decision table '" + dt.getName() + "': " + index, dt.getName(), dt.getName(), Collections.singletonList(index));
            });
            return results.get(0);
        }
        return null;
    }

    public static Object first(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        if (matches.size() >= 1) {
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                int index = ((DTDecisionRule)matches.get(0)).getIndex() + 1;
                return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rule fired for decision table '" + dt.getName() + "': " + index, dt.getName(), dt.getName(), Collections.singletonList(index));
            });
            return results.get(0);
        }
        return null;
    }

    public static Object any(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        if (matches.size() >= 1) {
            long distinctOutputEntry = results.stream().distinct().count();
            if (distinctOutputEntry > 1L) {
                throw new RuntimeException("multiple rules can match, but they [must] all have the same output");
            }
            FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
                int index = ((DTDecisionRule)matches.get(0)).getIndex() + 1;
                return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rule fired for decision table '" + dt.getName() + "': " + index, dt.getName(), dt.getName(), Collections.singletonList(index));
            });
            return results.get(0);
        }
        return null;
    }

    public static Object priority(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        if (matches.isEmpty()) {
            return null;
        }
        List<Pair<DTDecisionRule, Object>> pairs = HitPolicy.sortPairs(ctx, dt, matches, results);
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = Collections.singletonList(((DTDecisionRule)((Pair)pairs.get(0)).getLeft()).getIndex() + 1);
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return pairs.get(0).getRight();
    }

    public static Object outputOrder(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        if (matches.isEmpty()) {
            return null;
        }
        List<Pair<DTDecisionRule, Object>> pairs = HitPolicy.sortPairs(ctx, dt, matches, results);
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = pairs.stream().map(p -> ((DTDecisionRule)p.getLeft()).getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return pairs.stream().map(p -> p.getRight()).collect(Collectors.toList());
    }

    private static List<Pair<DTDecisionRule, Object>> sortPairs(EvaluationContext ctx, DecisionTableImpl dt, List<DTDecisionRule> matches, List<Object> results) {
        ArrayList<Pair<DTDecisionRule, Object>> pairs = new ArrayList<Pair<DTDecisionRule, Object>>();
        for (int i = 0; i < matches.size(); ++i) {
            pairs.add(new Pair<DTDecisionRule, Object>(matches.get(i), results.get(i)));
        }
        if (dt.getOutputs().size() == 1 && !dt.getOutputs().get(0).getOutputValues().isEmpty()) {
            List<UnaryTest> outs = dt.getOutputs().get(0).getOutputValues();
            pairs.sort((r1, r2) -> HitPolicy.sortByOutputsOrder(ctx, outs, r1.getRight(), r2.getRight()));
        } else if (dt.getOutputs().size() > 1) {
            List priorities = dt.getOutputs().stream().filter(o -> !o.getOutputValues().isEmpty()).collect(Collectors.toList());
            pairs.sort((r1, r2) -> {
                Map m1 = (Map)r1.getRight();
                Map m2 = (Map)r2.getRight();
                for (DTOutputClause oc : priorities) {
                    int o = HitPolicy.sortByOutputsOrder(ctx, oc.getOutputValues(), m1.get(oc.getName()), m2.get(oc.getName()));
                    if (o == 0) continue;
                    return o;
                }
                return 0;
            });
        }
        return pairs;
    }

    private static int sortByOutputsOrder(EvaluationContext ctx, List<UnaryTest> outs, Object r1, Object r2) {
        boolean r1found = false;
        boolean r2found = false;
        for (int index = 0; index < outs.size() && !r1found && !r2found; ++index) {
            UnaryTest ut = outs.get(index);
            if (((Boolean)ut.apply(ctx, r1)).booleanValue()) {
                r1found = true;
            }
            if (!((Boolean)ut.apply(ctx, r2)).booleanValue()) continue;
            r2found = true;
        }
        if (r1found && r2found) {
            return 0;
        }
        if (r1found) {
            return -1;
        }
        if (r2found) {
            return 1;
        }
        return 0;
    }

    public static Object ruleOrder(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        if (matches.isEmpty()) {
            return null;
        }
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = matches.stream().map(m -> m.getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return results;
    }

    public static <T> Collector<T, ?, Object> singleValueOrContext(List<DTOutputClause> outputs) {
        return new SingleValueOrContextCollector(outputs.stream().map(DTOutputClause::getName).collect(Collectors.toList()));
    }

    public static Object generalizedCollect(EvaluationContext ctx, DecisionTableImpl dt, List<?> results, Function<Stream<Object>, Object> resultCollector) {
        List names = dt.getOutputs().stream().map(o -> o.getName() != null ? o.getName() : dt.getName()).collect(Collectors.toList());
        List<Object> raw = names.size() > 1 ? results : results.stream().map(r -> Collections.singletonMap(names.get(0), r)).collect(Collectors.toList());
        return IntStream.range(0, names.size()).mapToObj(index -> (String)names.get(index)).map(name -> resultCollector.apply(raw.stream().map(r -> r.get(name)))).collect(HitPolicy.singleValueOrContext(dt.getOutputs()));
    }

    public static Object countCollect(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = matches.stream().map(m -> m.getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return HitPolicy.generalizedCollect(ctx, dt, results, x -> new BigDecimal(x.collect(Collectors.toSet()).size()));
    }

    public static Object minCollect(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        Object result = HitPolicy.generalizedCollect(ctx, dt, results, x -> x.map(y -> (Comparable)y).collect(Collectors.minBy(Comparator.naturalOrder())).orElse(null));
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = Collections.singletonList(((DTDecisionRule)matches.get(results.indexOf(result))).getIndex() + 1);
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return result;
    }

    public static Object maxCollect(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        Object result = HitPolicy.generalizedCollect(ctx, dt, results, x -> x.map(y -> (Comparable)y).collect(Collectors.maxBy(Comparator.naturalOrder())).orElse(null));
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = Collections.singletonList(((DTDecisionRule)matches.get(results.indexOf(result))).getIndex() + 1);
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return result;
    }

    public static Object sumCollect(EvaluationContext ctx, DecisionTableImpl dt, Object[] params, List<DTDecisionRule> matches, List<Object> results) {
        FEELEventListenersManager.notifyListeners(ctx.getEventsManager(), () -> {
            List<Integer> indexes = matches.stream().map(m -> m.getIndex() + 1).collect(Collectors.toList());
            return new DecisionTableRulesSelectedEvent(FEELEvent.Severity.INFO, "Rules fired for decision table '" + dt.getName() + "': " + indexes, dt.getName(), dt.getName(), indexes);
        });
        return HitPolicy.generalizedCollect(ctx, dt, results, x -> x.reduce(BigDecimal.ZERO, (a, b) -> {
            if (!(a instanceof Number) || !(b instanceof Number)) {
                return null;
            }
            BigDecimal aB = new BigDecimal(((Number)a).toString());
            BigDecimal bB = new BigDecimal(((Number)b).toString());
            return aB.add(bB);
        }));
    }

    @FunctionalInterface
    public static interface HitPolicyDTI {
        public Object dti(EvaluationContext var1, DecisionTableImpl var2, Object[] var3, List<DTDecisionRule> var4, List<Object> var5);
    }
}

