/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.ExecutionFrame;
import org.kie.dmn.feel.lang.impl.ExecutionFrameImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.impl.RootExecutionFrame;
import org.kie.dmn.feel.util.EvalHelper;

public class EvaluationContextImpl
implements EvaluationContext {
    private final FEELEventListenersManager eventsManager;
    private Stack<ExecutionFrame> stack;

    public EvaluationContextImpl(FEELEventListenersManager eventsManager) {
        this.eventsManager = eventsManager;
        this.stack = new Stack();
        this.push(RootExecutionFrame.INSTANCE);
        ExecutionFrameImpl global = new ExecutionFrameImpl(RootExecutionFrame.INSTANCE);
        this.push(global);
    }

    public void push(ExecutionFrame obj) {
        this.stack.push(obj);
    }

    public ExecutionFrame pop() {
        return this.stack.pop();
    }

    public ExecutionFrame peek() {
        return this.stack.peek();
    }

    public Stack<ExecutionFrame> getStack() {
        return this.stack;
    }

    @Override
    public void enterFrame() {
        this.push(new ExecutionFrameImpl(this.peek()));
    }

    @Override
    public void exitFrame() {
        this.pop();
    }

    @Override
    public void setValue(String name, Object value) {
        this.peek().setValue(name, EvalHelper.coerceNumber(value));
    }

    @Override
    public Object getValue(String name) {
        return this.peek().getValue(name);
    }

    @Override
    public Object getValue(String[] name) {
        throw new UnsupportedOperationException("needs implementation?");
    }

    @Override
    public boolean isDefined(String name) {
        return this.peek().isDefined(name);
    }

    @Override
    public boolean isDefined(String[] name) {
        throw new UnsupportedOperationException("needs implementation?");
    }

    @Override
    public Map<String, Object> getAllValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < this.stack.size(); ++i) {
            values.putAll(((ExecutionFrame)this.stack.get(i)).getAllValues());
        }
        return values;
    }

    @Override
    public FEELEventListenersManager getEventsManager() {
        return this.eventsManager;
    }
}

