/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class TimeFunction
extends BaseFEELFunction {
    private static final BigDecimal NANO_MULT = BigDecimal.valueOf(1000000000L);

    public TimeFunction() {
        super("time");
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") String val) {
        if (val == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult(DateTimeFormatter.ISO_TIME.parseBest(val, OffsetTime::from, LocalTime::from));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "time-parsing exception", e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="hour") Number hour, @ParameterName(value="minute") Number minute, @ParameterName(value="second") Number seconds, @ParameterName(value="offset") Duration offset) {
        if (hour == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "hour", "cannot be null"));
        }
        if (minute == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "minute", "cannot be null"));
        }
        if (seconds == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "seconds", "cannot be null"));
        }
        try {
            int nanosecs = 0;
            if (seconds instanceof BigDecimal) {
                BigDecimal secs = (BigDecimal)seconds;
                nanosecs = secs.subtract(secs.setScale(0, 1)).multiply(NANO_MULT).intValue();
            }
            if (offset == null) {
                return FEELFnResult.ofResult(LocalTime.of(hour.intValue(), minute.intValue(), seconds.intValue(), nanosecs));
            }
            return FEELFnResult.ofResult(OffsetTime.of(hour.intValue(), minute.intValue(), seconds.intValue(), nanosecs, ZoneOffset.ofTotalSeconds((int)offset.getSeconds())));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "time-parsing exception", e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="from") TemporalAccessor date) {
        if (date == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        try {
            if (date.query(TemporalQueries.offset()) == null) {
                return FEELFnResult.ofResult(LocalTime.from(date));
            }
            return FEELFnResult.ofResult(OffsetTime.from(date));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "time-parsing exception", e));
        }
    }
}

