/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.DynamicTypeUtils;

public class MapBackedTypeTest {
    @Test
    public void testBasic() {
        MapBackedType personType = new MapBackedType("Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("First Name", BuiltInType.STRING), DynamicTypeUtils.entry("Last Name", BuiltInType.STRING)));
        Map aPerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"), DynamicTypeUtils.entry("Last Name", "Doe"));
        Assert.assertTrue((boolean)personType.isAssignableValue(aPerson));
        Assert.assertTrue((boolean)personType.isInstanceOf(aPerson));
        Map aCompletePerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"), DynamicTypeUtils.entry("Last Name", "Doe"), DynamicTypeUtils.entry("Address", "100 East Davie Street"));
        Assert.assertTrue((boolean)personType.isAssignableValue(aCompletePerson));
        Assert.assertTrue((boolean)personType.isInstanceOf(aCompletePerson));
        Map notAPerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"));
        Assert.assertFalse((boolean)personType.isAssignableValue(notAPerson));
        Assert.assertFalse((boolean)personType.isInstanceOf(notAPerson));
        Map anonymousPerson1 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", null), DynamicTypeUtils.entry("Last Name", "Doe"));
        Assert.assertTrue((boolean)personType.isAssignableValue(anonymousPerson1));
        Assert.assertTrue((boolean)personType.isInstanceOf(anonymousPerson1));
        Map anonymousPerson2 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"), DynamicTypeUtils.entry("Last Name", null));
        Assert.assertTrue((boolean)personType.isAssignableValue(anonymousPerson2));
        Assert.assertTrue((boolean)personType.isInstanceOf(anonymousPerson2));
        Map anonymousPerson3 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", null), DynamicTypeUtils.entry("Last Name", null));
        Assert.assertTrue((boolean)personType.isAssignableValue(anonymousPerson3));
        Assert.assertTrue((boolean)personType.isInstanceOf(anonymousPerson3));
        Map anonymousCompletePerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", null), DynamicTypeUtils.entry("Last Name", null), DynamicTypeUtils.entry("Address", "100 East Davie Street"));
        Assert.assertTrue((boolean)personType.isAssignableValue(anonymousCompletePerson));
        Assert.assertTrue((boolean)personType.isInstanceOf(anonymousCompletePerson));
        Object nullPerson = null;
        Assert.assertTrue((boolean)personType.isAssignableValue(nullPerson));
        Assert.assertFalse((boolean)personType.isInstanceOf(nullPerson));
    }
}

