/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.StringUpperCaseFunction;

public class StringUpperCaseFunctionTest {
    private StringUpperCaseFunction stringUpperCaseFunction;

    @Before
    public void setUp() {
        this.stringUpperCaseFunction = new StringUpperCaseFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.stringUpperCaseFunction.invoke(null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeLowercaseString() {
        FunctionTestUtil.assertResult(this.stringUpperCaseFunction.invoke("teststring"), "TESTSTRING");
    }

    @Test
    public void invokeUppercaseString() {
        FunctionTestUtil.assertResult(this.stringUpperCaseFunction.invoke("TESTSTRING"), "TESTSTRING");
    }

    @Test
    public void invokeMixedCaseString() {
        FunctionTestUtil.assertResult(this.stringUpperCaseFunction.invoke("testSTRing"), "TESTSTRING");
    }
}

