/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.kie.dmn.feel.lang.FEELProperty;
import org.kie.dmn.feel.util.EvalHelper;

public class EvalHelperTest {
    @Test
    public void testNormalizeSpace() {
        Assertions.assertThat((String)EvalHelper.normalizeVariableName(null)).isNull();
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)" ")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\t")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\n")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\t")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\u000b")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\f")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\u001c")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\u001d")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\u001e")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\u001f")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\f")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"\r")).isEqualTo("");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"  a  ")).isEqualTo("a");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"  a  b   c  ")).isEqualTo("a b c");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"a\t\f\r  b\u000b   c\n")).isEqualTo("a b c");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"a\t\f\r  \u00a0\u00a0b\u000b   c\n")).isEqualTo("a b c");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)" b")).isEqualTo("b");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"b ")).isEqualTo("b");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"ab c  ")).isEqualTo("ab c");
        Assertions.assertThat((String)EvalHelper.normalizeVariableName((String)"a\u00a0b")).isEqualTo("a b");
    }

    @Test
    public void testGetBigDecimalOrNull() {
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)10.0)).isEqualTo((Object)new BigDecimal("10"));
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)10.0)).isEqualTo((Object)new BigDecimal("10"));
        Assertions.assertThat((BigDecimal)EvalHelper.getBigDecimalOrNull((Object)1.00000000005E10)).isEqualTo((Object)new BigDecimal("10000000000.5"));
    }

    @Test
    public void testGetGenericAccessor() throws NoSuchMethodException {
        Method expectedAccessor = TestPojo.class.getMethod("getAProperty", new Class[0]);
        ((ObjectAssert)Assertions.assertThat((Object)EvalHelper.getGenericAccessor(TestPojo.class, (String)"aProperty")).as("getGenericAccessor should work on Java bean accessors.", new Object[0])).isEqualTo((Object)expectedAccessor);
        ((ObjectAssert)Assertions.assertThat((Object)EvalHelper.getGenericAccessor(TestPojo.class, (String)"feelPropertyIdentifier")).as("getGenericAccessor should work for methods annotated with '@FEELProperty'.", new Object[0])).isEqualTo((Object)expectedAccessor);
    }

    private static class TestPojo {
        private TestPojo() {
        }

        @FEELProperty(value="feelPropertyIdentifier")
        public String getAProperty() {
            return null;
        }
    }
}

