/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class PersonsTest
extends BaseDMNOASTest {
    @Test
    public void test() throws Exception {
        DMNRuntime runtime = this.createRuntime("persons.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_4766A842-0524-4727-979B-45BF678F2F36", "persons");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"ps1\": [{\"name\":\"John Doe\", \"age\": 47}], \"ps2\": [{\"name\":\"John Doe\", \"age\": 47}] }")).isEmpty();
    }
}

