/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class NumberAllowedValuesTest
extends BaseDMNOASTest {
    @Test
    public void testAllowedValues() throws Exception {
        DMNRuntime runtime = this.createRuntime("numberAllowedValues.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("ns1", "numberAllowedValues");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"gt0\": 123, \"lteq47gt0\": 47, \"r0100\": 0}")).isEmpty();
    }

    @Test
    public void testNumberList() throws Exception {
        DMNRuntime runtime = this.createRuntime("numberList.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("ns1", "numberList");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"in1\": 47 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"in1\": 0 }")).isEmpty();
    }
}

