/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class TypeWithSpaceTest
extends BaseDMNOASTest {
    @Test
    public void test() throws Exception {
        DMNRuntime runtime = this.createRuntime("typeWithSpace.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("ns1", "typeWithSpace");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"a Person\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"a Person\": { \"full name\":123 } }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"a Person\": { \"full name\": \"John Doe\" } }")).isEmpty();
    }
}

