/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.DMNRuntimeTest;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class AllowNullTest
extends BaseDMNOASTest {
    @Test
    public void testVowels() throws Exception {
        DMNRuntime runtime = this.createRuntime("vowels.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_0885BF04-027C-4743-9427-2668DA3AD472", "vowels");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"my input\": \"#FF0000\" }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"my input\": null }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"my input\": \"a\"}")).isEmpty();
    }

    @Test
    public void testVowelsAllowNull() throws Exception {
        DMNRuntime runtime = this.createRuntime("vowelsAllowNull.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_0885BF04-027C-4743-9427-2668DA3AD472", "vowels");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"my input\": \"#FF0000\" }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"my input\": null }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"my input\": \"a\" }")).isEmpty();
    }

    @Test
    public void testSoundItemDefAllowNull() throws Exception {
        DMNRuntime runtime = this.createRuntime("RecommenderHitPolicy1_allowNull_itemDef.dmn", DMNRuntimeTest.class);
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("http://www.trisotech.com/definitions/_50aea0bb-4482-48f6-acfe-4abc1a1bd0d6", "Drawing 1");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Level\": \"#FF0000\" }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Level\": null }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Level\": 47 }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Level\": -999 }")).isNotEmpty();
    }
}

