/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.v1_4.DMN14specificTest;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class CH11Test
extends BaseDMNOASTest {
    @Test
    public void test_dmn14support() throws Exception {
        DMNRuntime runtime = this.createRuntimeWithAdditionalResources("Chapter 11 Example.dmn", DMN14specificTest.class, "Financial.dmn");
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("http://www.trisotech.com/definitions/_9d01a0c4-f529-4ad8-ad8e-ec5fb5d96ad4", "Chapter 11 Example");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{\n    \"Applicant data\": {\n        \"ExistingCustomer\": false,\n        \"EmploymentStatus\": \"EMPLOYED\",\n        \"Age\": 51,\n        \"Monthly\": {\n            \"Income\": 100000,\n            \"Repayments\": 2500,\n            \"Expenses\": 10000\n        },\n        \"MartitalStatus\": \"M\"\n    },\n    \"Requested product\": {\n        \"Amount\": 100000,\n        \"ProductType\": \"STANDARD LOAN\",\n        \"Rate\": 0.08,\n        \"Term\": 36\n    },\n    \"Supporting documents\": null,\n    \"Bureau data\": {\n        \"Bankrupt\": false,\n        \"CreditScore\": 600\n    },\n    \"Loan default data\": \"\"\n}")).isEmpty();
    }
}

