/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.EvalHelper;

public class MonthFunction
extends BaseFEELFunction {
    public MonthFunction() {
        super("month");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="datestring") String val) {
        if (val == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datestring", "cannot be null"));
        }
        try {
            Object r = ((DateFunction)BuiltInFunctions.getFunction(DateFunction.class)).invoke(val).cata(BuiltInType.justNull(), Function.identity());
            if (r != null && r instanceof TemporalAccessor) {
                return this.invoke((TemporalAccessor)r);
            }
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datestring", "date-parsing exception"));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datestring", "date-parsing exception", (Throwable)e));
        }
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="datetime") TemporalAccessor datetime) {
        if (datetime == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult((Object)EvalHelper.getBigDecimalOrNull((Object)datetime.get(ChronoField.MONTH_OF_YEAR)));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "invalid 'date' or 'date and time' parameter", (Throwable)e));
        }
    }
}

