/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.io.FileSystemResource;
import org.drools.io.ReaderResource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.kie.api.io.Resource;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.internal.utils.ChainedProperties;

public abstract class AbstractValidatorTest {
    protected static DMNValidator validator;
    protected static DMNMarshaller marshaller;

    @BeforeAll
    public static void init() {
        List defaultDMNProfiles = DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)ChainedProperties.getChainedProperties((ClassLoader)ClassLoaderUtil.findDefaultClassLoader()));
        validator = DMNValidatorFactory.newValidator((List)defaultDMNProfiles);
        List extensionRegisters = defaultDMNProfiles.stream().flatMap(dmnp -> dmnp.getExtensionRegisters().stream()).collect(Collectors.toList());
        marshaller = !extensionRegisters.isEmpty() ? DMNMarshallerFactory.newMarshallerWithExtensions(extensionRegisters) : DMNMarshallerFactory.newDefaultMarshaller();
    }

    @AfterAll
    public static void dispose() {
        if (validator != null) {
            validator.dispose();
        }
    }

    protected Reader getReader(String resourceFileName) {
        return this.getReader(resourceFileName, this.getClass());
    }

    protected Reader getReader(String resourceFileName, Class<?> clazz) {
        return new InputStreamReader(clazz.getResourceAsStream(resourceFileName));
    }

    protected File getFile(String resourceFileName) {
        return new File(this.getClass().getResource(resourceFileName).getFile());
    }

    protected Resource getResource(String resourceFileName) {
        return new FileSystemResource(new File(this.getClass().getResource(resourceFileName).getFile()));
    }

    protected Resource getResource(String resourceFileName, Class<?> clazz) {
        return new ReaderResource((Reader)new InputStreamReader(clazz.getResourceAsStream(resourceFileName)));
    }

    protected Definitions getDefinitions(String resourceName, String namespace, String modelName) {
        Definitions definitions = marshaller.unmarshal(this.getReader(resourceName));
        Assertions.assertThat((Object)definitions).isNotNull();
        Assertions.assertThat((String)definitions.getNamespace()).isEqualTo(namespace);
        Assertions.assertThat((String)definitions.getName()).isEqualTo(modelName);
        return definitions;
    }

    protected Definitions getDefinitions(Reader resourceReader, String namespace, String modelName) {
        Definitions definitions = marshaller.unmarshal(resourceReader);
        Assertions.assertThat((Object)definitions).isNotNull();
        Assertions.assertThat((String)definitions.getNamespace()).isEqualTo(namespace);
        Assertions.assertThat((String)definitions.getName()).isEqualTo(modelName);
        return definitions;
    }

    protected Definitions getDefinitions(List<String> resourcesName, String namespace, String modelName) {
        if (resourcesName.size() < 2) {
            throw new RuntimeException("use proper method");
        }
        List definitionss = resourcesName.stream().map(this::getReader).map(arg_0 -> ((DMNMarshaller)marshaller).unmarshal(arg_0)).collect(Collectors.toList());
        Assertions.assertThat(definitionss).isNotEmpty();
        Optional<Definitions> definitions = definitionss.stream().filter(d -> d.getNamespace().equals(namespace) && d.getName().equals(modelName)).findFirst();
        Assertions.assertThat((boolean)definitions.isPresent()).isTrue();
        return definitions.get();
    }
}

