/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.model.api.Context;
import org.kie.dmn.model.api.ContextEntry;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

class ValidatorContextTest
extends AbstractValidatorTest {
    ValidatorContextTest() {
    }

    @Test
    void context_missing_expr_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_MISSING_EXPR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        }
    }

    @Test
    void context_missing_expr_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void context_missing_expr_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_MISSING_EXPR.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void context_missing_entries_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_MISSING_ENTRIES.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        }
    }

    @Test
    void context_missing_entries_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_MISSING_ENTRIES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void context_missing_entries_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_MISSING_ENTRIES.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void context_entry_missing_variable_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_ENTRY_MISSING_VARIABLE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
            ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
            Assertions.assertThat((int)((Context)ce.getParent()).getContextEntry().indexOf(ce)).isEqualTo(1);
        }
    }

    @Test
    void context_entry_missing_variable_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_ENTRY_MISSING_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
        ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
        Assertions.assertThat((int)((Context)ce.getParent()).getContextEntry().indexOf(ce)).isEqualTo(1);
    }

    @Test
    void context_entry_missing_variable_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_ENTRY_MISSING_VARIABLE.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
        ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
        Assertions.assertThat((int)((Context)ce.getParent()).getContextEntry().indexOf(ce)).isEqualTo(1);
    }

    @Test
    void context_dup_entry_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_DUP_ENTRY.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
        }
    }

    @Test
    void context_dup_entry_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_DUP_ENTRY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
    }

    @Test
    void context_dup_entry_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_DUP_ENTRY.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_DUP_ENTRY"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
    }

    @Test
    void context_entry_notyperef_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_ENTRY_NOTYPEREF.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
        }
    }

    @Test
    void context_entry_notyperef_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_ENTRY_NOTYPEREF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
    }

    @Test
    void context_entry_notyperef_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_ENTRY_NOTYPEREF.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_ENTRY_NOTYPEREF"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
    }
}

