/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidatorDMN14Test
extends AbstractValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorDMN14Test.class);

    ValidatorDMN14Test() {
    }

    @Test
    void simpleReaderInput() throws IOException {
        try (Reader reader = this.getReader("dmn14simple.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assertions.assertThat((List)validate).hasSize(0);
        }
    }

    @Test
    void simpleFileInput() {
        List validate = validator.validate(this.getFile("dmn14simple.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    void simpleDefintionsInput() {
        List validate = validator.validate(this.getDefinitions("dmn14simple.dmn", "http://www.trisotech.com/definitions/_d9232146-7aaa-49a9-8668-261a01844ace", "Drawing 1"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    void boxedExtensionConditional14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/conditional.dmn")});
        LOG.debug("{}", (Object)validate);
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    void boxedExtensionIterator14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/iterator.dmn")});
        LOG.debug("{}", (Object)validate);
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    void boxedExtensionIteratorDataType14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/iterator-datatype.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    void boxedExtensionFilter14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/filter.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    void boxedExtensionFilterDataType14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/filter-datatype.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }
}

