/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

class ValidatorDMNDITest
extends AbstractValidatorTest {
    ValidatorDMNDITest() {
    }

    @Test
    void allElements() throws IOException {
        try (Reader reader = this.getReader("dmndi/all-elements.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        }
    }

    @Test
    void missingDmnshapeMissingDmnedge() throws IOException {
        try (Reader reader = this.getReader("dmndi/all-elements-with-dmndi-no-dmnshape.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(12);
            Assertions.assertThat((long)validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.DMNDI_MISSING_DIAGRAM)).count()).isEqualTo(12L);
        }
    }

    @Test
    void unknownRef() throws IOException {
        try (Reader reader = this.getReader("dmndi/all-elements-invalid-ref.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(24);
            Assertions.assertThat((long)validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.DMNDI_MISSING_DIAGRAM)).count()).isEqualTo(12L);
            Assertions.assertThat((long)validate.stream().filter(p -> p.getLevel() == Message.Level.ERROR && p.getMessageType().equals((Object)DMNMessageType.DMNDI_UNKNOWN_REF)).count()).isEqualTo(12L);
        }
    }
}

