/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidatorDecisionServiceTest
extends AbstractValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorDecisionServiceTest.class);

    ValidatorDecisionServiceTest() {
    }

    @Test
    void output_not_found_for_ds_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/HelloDS_noOutput.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        }
    }

    @Test
    void output_not_found_for_ds_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/HelloDS_noOutput.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void output_not_found_for_ds_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/HelloDS_noOutput.dmn", "https://kiegroup.org/dmn/_7C3C7416-2F33-4718-AE35-F3843C5250DB", "HelloDS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void okds() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"decisionservice/HelloDS_OK.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_7C3C7416-2F33-4718-AE35-F3843C5250DB", "HelloDS");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)definitions).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).as(messages.toString(), new Object[0])).hasSize(0);
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, runtime.newContext());
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Decision-1").getResult()).isEqualTo((Object)"Hello World");
    }

    @Test
    void dS1ofEach() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"decisionservice/DS1ofEach_OK.dmn", this.getClass());
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)definitions).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).as(messages.toString(), new Object[0])).hasSize(0);
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("InputData-1", (Object)"id1");
        dmnContext.set("Decision-1", (Object)"od1");
        DMNResult evaluateDS1 = runtime.evaluateDecisionService(dmnModel, dmnContext, "DecisionService-1");
        LOG.debug("{}", (Object)evaluateDS1);
        Assertions.assertThat((Object)evaluateDS1.getDecisionResultByName("Decision-2")).isNull();
        Assertions.assertThat((Object)evaluateDS1.getDecisionResultByName("Decision-3").getResult()).isEqualTo((Object)"d3:d2:id1od1");
    }

    @Test
    void encapsulated_not_found_for_ds_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingEncapsulated.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        }
    }

    @Test
    void encapsulated_not_found_for_ds_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingEncapsulated.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void encapsulated_not_found_for_ds_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingEncapsulated.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThanOrEqualTo(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void decisioninput_not_found_for_ds_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingDecisionInput.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        }
    }

    @Test
    void decisioninput_not_found_for_ds_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingDecisionInput.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void decisioninput_not_found_for_ds_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingDecisionInput.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThanOrEqualTo(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void inputdata_not_found_for_ds_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingInputData.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        }
    }

    @Test
    void inputdata_not_found_for_ds_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingInputData.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void inputdata_not_found_for_ds_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingInputData.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThanOrEqualTo(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(1)).getMessageType()).as(((DMNMessage)validate.get(1)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void outputelement_not_found_for_ds_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decisionservice/DS1ofEach_missingOutput.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
        }
    }

    @Test
    void outputelement_not_found_for_ds_FileInput() {
        List validate = validator.validate(this.getFile("decisionservice/DS1ofEach_missingOutput.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }

    @Test
    void outputelement_not_found_for_ds_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decisionservice/DS1ofEach_missingOutput.dmn", "https://kiegroup.org/dmn/_40B3D02F-868C-4925-A1F2-5710DFEEF51E", "DS1ofEach"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThanOrEqualTo(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.REQ_NOT_FOUND);
    }
}

