/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

class ValidatorDecisionTableTest
extends AbstractValidatorTest {
    ValidatorDecisionTableTest() {
    }

    @Test
    void dtable_empty_entry_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_EMPTY_ENTRY.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        }
    }

    @Test
    void dtable_empty_entry_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_EMPTY_ENTRY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void dtable_empty_entry_DefintionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_EMPTY_ENTRY.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_MISSING_OUTVALS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void dtable_multipleout_name_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(6);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
        }
    }

    @Test
    void dtable_multipleout_name_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(6);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
    }

    @Test
    void dtable_multipleout_name_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(6);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
    }

    @Test
    void dtable_priority_missing_outvals_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_PRIORITY_MISSING_OUTVALS.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES))).isTrue();
        }
    }

    @Test
    void dtable_priority_missing_outvals_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_PRIORITY_MISSING_OUTVALS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES))).isTrue();
    }

    @Test
    void dtable_priority_missing_outvals_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_PRIORITY_MISSING_OUTVALS.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_MISSING_OUTVALS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES))).isTrue();
    }

    @Test
    void dtable_singleout_noname_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF))).isTrue();
        }
    }

    @Test
    void dtable_singleout_noname_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF))).isTrue();
    }

    @Test
    void dtable_singleout_noname_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_SINGLEOUTPUT_WRONG_OUTPUT"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF))).isTrue();
    }
}

