/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.DMNRuntimeTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;

class ValidatorDecisionTest
extends AbstractValidatorTest {
    ValidatorDecisionTest() {
    }

    @Test
    void decision_missing_expr_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_EXPR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
        }
    }

    @Test
    void decision_missing_expr_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    void decision_missing_expr_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_EXPR.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    void decision_missing_var_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_VAR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
        }
    }

    @Test
    void decision_missing_var_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
    }

    @Test
    void decision_missing_var_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_VAR.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_VAR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
    }

    @Test
    void decision_missing_vaRbisReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_VARbis.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
        }
    }

    @Test
    void decision_missing_vaRbisFileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_VARbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
    }

    @Test
    void decision_missing_vaRbisDefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_VARbis.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_VARbis"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE))).isTrue();
    }

    @Test
    void decision_mismatch_var_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISMATCH_VAR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH))).isTrue();
        }
    }

    @Test
    void decision_mismatch_var_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH))).isTrue();
    }

    @Test
    void decision_mismatch_var_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISMATCH_VAR.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_VAR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH))).isTrue();
    }

    @Test
    void decision_multiple_expressions_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION))).isTrue();
        }
    }

    @Test
    void decision_multiple_expressions_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION))).isTrue();
    }

    @Test
    void decision_multiple_expressions_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MULTIPLE_EXPRESSIONS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void decision_perf_indicator_wrong_type_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void decision_perf_indicator_wrong_type_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_perf_indicator_wrong_type_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_PERF_INDICATOR_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_decision_maker_wrong_type_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void decision_decision_maker_wrong_type_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_decision_maker_wrong_type_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DECISION_MAKER_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_decision_owner_wrong_type_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void decision_decision_owner_wrong_type_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_decision_owner_wrong_type_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DECISION_MAKER_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_cyclic_dependency_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_CYCLIC_DEPENDENCY.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void decision_cyclic_dependency_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_CYCLIC_DEPENDENCY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_cyclic_dependency_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_CYCLIC_DEPENDENCY.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_CYCLIC_DEPENDENCY"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_cyclic_dependency_self_reference_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void decision_cyclic_dependency_self_reference_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_cyclic_dependency_self_reference_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_deadly_diamond_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DEADLY_DIAMOND.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        }
    }

    @Test
    void decision_deadly_diamond_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DEADLY_DIAMOND.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void decision_deadly_diamond_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DEADLY_DIAMOND.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DEADLY_DIAMOND"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void decision_deadly_kite_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DEADLY_KITE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        }
    }

    @Test
    void decision_deadly_kite_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DEADLY_KITE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void decision_deadly_kite_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DEADLY_KITE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DEADLY_KITE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void decision_missing_req_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_REQ.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void decision_missing_req_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_REQ.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void decision_missing_req_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_REQ.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_REQ"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void dTCollectOperatorsMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"multipleOutputsCollectDT.dmn", DMNRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_943A3581-5FD1-4BCF-9A52-AC7242CC451C", "multipleOutputsCollectDT");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)definitions).isNotNull();
        List validate = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().allMatch(p -> p.getLevel() == Message.Level.WARNING && p.getText().contains("Collect with Operator for compound outputs"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
    }
}

