/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

class ValidatorKnowledgeRequirementTest
extends AbstractValidatorTest {
    ValidatorKnowledgeRequirementTest() {
    }

    @Test
    void knowreq_missing_bkm_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("knowledgerequirement/KNOWREQ_MISSING_BKM.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void knowreq_missing_bkm_FileInput() {
        List validate = validator.validate(this.getFile("knowledgerequirement/KNOWREQ_MISSING_BKM.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void knowreq_missing_bkm_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("knowledgerequirement/KNOWREQ_MISSING_BKM.dmn", "https://github.com/kiegroup/kie-dmn", "KNOWREQ_MISSING_BKM"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void knowreq_req_decision_not_bkm_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("knowledgerequirement/KNOWREQ_REQ_DECISION_NOT_BKM.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
        }
    }

    @Test
    void knowreq_req_decision_not_bkm_FileInput() {
        List validate = validator.validate(this.getFile("knowledgerequirement/KNOWREQ_REQ_DECISION_NOT_BKM.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    void knowreq_req_decision_not_bkm_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("knowledgerequirement/KNOWREQ_REQ_DECISION_NOT_BKM.dmn", "https://github.com/kiegroup/kie-dmn", "KNOWREQ_REQ_DECISION_NOT_BKM"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }
}

