/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.io.ClassPathResource;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.DMNInputRuntimeTest;
import org.kie.dmn.core.DMNRuntimeTest;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.core.decisionservices.DMNDecisionServicesTest;
import org.kie.dmn.core.imports.ImportsTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.v1_3.DMN13specificTest;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidatorTest
extends AbstractValidatorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatorTest.class);
    static final DMNValidator validator = DMNValidatorFactory.newValidator(List.of(new ExtendedDMNProfile()));
    static final DMNValidator.ValidatorBuilder validatorBuilder = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});

    ValidatorTest() {
    }

    @Test
    void dryRun() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNValidatorFactory.newValidator().validate(definitions);
    }

    @Test
    void macdInputDefinitions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"MACD-enhanced_iteration.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6cfe7d88-6741-45d1-968c-b61a597d0964", "MACD-enhanced iteration");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)dmnModel).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).as(messages.toString(), new Object[0])).hasSize(0);
    }

    @Test
    void macdInputReader() throws IOException {
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/org/kie/dmn/core/MACD-enhanced_iteration.dmn")));){
            List messages = DMNValidatorFactory.newValidator().validate((Reader)reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)messages).withFailMessage(messages.toString(), new Object[0])).hasSize(0);
        }
    }

    @Test
    void invalidXml() throws URISyntaxException {
        List validateXML = validator.validate(new File(this.getClass().getResource("invalidXml.dmn").toURI()), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA});
        ((ListAssert)Assertions.assertThat((List)validateXML).withFailMessage(ValidatorUtil.formatMessages((List)validateXML), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validateXML.get(0)).getMessageType()).withFailMessage(((DMNMessage)validateXML.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.FAILED_XML_VALIDATION);
        Assertions.assertThat((String)((DMNMessage)validateXML.get(0)).getPath()).contains(new CharSequence[]{"invalidXml.dmn"});
    }

    @Test
    void invocationMissingExpr() {
        List validate = validator.validate(this.getReader("INVOCATION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).withFailMessage(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    void nameIsValid() {
        List validate = validator.validate(this.getReader("NAME_IS_VALID.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void name_invalidEmptyName() {
        List validate = validator.validate(this.getReader("DROOLS-1447.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(5);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_5e43b55c-888e-443c-b1b9-80e4aa6746bd"))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_b1e4588e-9ce1-4474-8e4e-48dbcdb7524b"))).isTrue();
    }

    @Test
    void name_emptyEmptyModelName() {
        List validate = validator.validate(this.getReader("EmptyModelName.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_f27bb64b-6fc7-4e1f-9848-11ba35e0df44"))).isTrue();
    }

    @Test
    void drgelemNotUnique() {
        List validate = validator.validate(this.getReader("DRGELEM_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
    }

    @Test
    void formalParamDuplicated() {
        List validate = validator.validate(this.getReader("FORMAL_PARAM_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(3);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_PARAM))).isTrue();
    }

    @Test
    void invocationInconsistentParamNames() {
        List validate = validator.validate(this.getReader("INVOCATION_INCONSISTENT_PARAM_NAMES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH))).isTrue();
    }

    @Test
    @Disabled(value="Needs to be improved as invocations can be used to invoke functions node defined in BKMs. E.g., FEEL built in functions, etc.")
    void invocationMissingTarget() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGET.dmn");
        List validate = validator.validate(definitions);
    }

    @Disabled(value="known current limitation")
    @Test
    void invocation_missing_targetRbis() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGETbis.dmn");
        List validate = validator.validate(definitions);
    }

    @Test
    void invocationWrongParamCount() {
        List validate = validator.validate(this.getReader("INVOCATION_WRONG_PARAM_COUNT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH))).isTrue();
    }

    @Test
    void itemcompDuplicated() {
        List validate = validator.validate(this.getReader("ITEMCOMP_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF))).isTrue();
    }

    @Test
    void itemdefNotUnique() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(3);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF))).isTrue();
    }

    @Test
    void itemdefNotUniqueDrools1450() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE_DROOLS-1450.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void relationDupColumn() {
        List validate = validator.validate(this.getReader("RELATION_DUP_COLUMN.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_RELATION_COLUMN))).isTrue();
    }

    @Test
    void relationRowCellNotliteral() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELL_NOTLITERAL.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_NOT_LITERAL))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    void relationRowCellcountmismatch() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELLCOUNTMISMATCH.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_COUNT_MISMATCH))).isTrue();
    }

    @Test
    void mortgageRecommender() {
        List validate = validator.validate(this.getReader("MortgageRecommender.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
    }

    @Test
    void reqauth_not_knowledgesourcEbis() {
        List validate = validator.validate(this.getReader("REQAUTH_NOT_KNOWLEDGESOURCEbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
    }

    @Test
    void variableLeadingTrailingSpaces() {
        List validate = validator.validate(this.getReader("VARIABLE_LEADING_TRAILING_SPACES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
        Assertions.assertThat((List)validate).anySatisfy(p -> {
            Assertions.assertThat((Comparable)p.getMessageType()).isEqualTo((Object)DMNMessageType.INVALID_NAME);
            Assertions.assertThat((String)p.getSourceId()).isEqualTo("_dd662d27-7896-42cb-9d14-bd74203bdbec");
        });
        Assertions.assertThat((List)validate).anySatisfy(p -> {
            Assertions.assertThat((Comparable)p.getMessageType()).isEqualTo((Object)DMNMessageType.INVALID_NAME);
            Assertions.assertThat((String)p.getSourceId()).isEqualTo("_1f54fd51-6805-4280-b576-607450f85edd");
        });
    }

    @Test
    void nameNotNormalized() {
        List validate = validator.validate(this.getReader("NAME_NOT_NORMALIZED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
        Assertions.assertThat((List)validate).anySatisfy(p -> {
            Assertions.assertThat((Comparable)p.getMessageType()).isEqualTo((Object)DMNMessageType.INVALID_NAME);
            Assertions.assertThat((String)p.getSourceId()).isEqualTo("_7E95B3C8-9276-46EA-87D4-22FDE87DC039");
        });
        Assertions.assertThat((List)validate).anySatisfy(p -> {
            Assertions.assertThat((Comparable)p.getMessageType()).isEqualTo((Object)DMNMessageType.INVALID_NAME);
            Assertions.assertThat((String)p.getSourceId()).isEqualTo("_07210027-8B43-4DA0-8C0D-69D3E695D23D");
        });
    }

    @Test
    void unknownVariable() {
        List validate = validator.validate(this.getReader("UNKNOWN_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
    }

    @Test
    void unknownOperator() {
        List validate = validator.validate(this.getReader("UNKNOWN_OPERATOR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
    }

    @Test
    void validation() {
        List validate = validator.validate(this.getReader("validation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(7);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
    }

    @Test
    void usingSemanticNamespacePrefix() {
        List validate = validator.validate(this.getReader("UsingSemanticNS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void usingSemanticNamespacePrefixAndExtensions() {
        List validate = validator.validate(this.getReader("Hello_World_semantic_namespace_with_extensions.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void noPrefixAndExtensions() {
        List validate = validator.validate(this.getReader("Hello_World_no_prefix_with_extensions.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void relationwithemptycell() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"relation_with_empty_cell.dmn", DMNRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_99a00903-2943-47df-bab1-a32f276617ea", "Relation with empty cell");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)dmnModel).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).withFailMessage(messages.toString(), new Object[0])).hasSize(0);
    }

    @Test
    void relationwithemptycellJustValidator() {
        List validate = validator.validate(this.getReader("relation_with_empty_cell.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void boxedInvocationMissingExpression() {
        List validate = validator.validate(this.getReader("DROOLS-2813-NPE-BoxedInvocationMissingExpression.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_a111c4df-c5b5-4d84-81e7-3ec735b50d06"))).isTrue();
    }

    @Test
    void dMNv12Ch11Modified() {
        List validate = validator.validate(this.getReader("v1_2/ch11MODIFIED.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void dMNv12Ch11() {
        List validate = validator.validate(this.getReader("DMNv12_ch11.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("d_Adjudication"))).isTrue();
    }

    @Test
    void decisionServiceCompiler20180830() {
        List validate = validator.validate(this.getReader("DecisionServiceABC.dmn", DMNDecisionServicesTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void decisionServiceCompiler20180830DMNV12() {
        List validate = validator.validate(this.getReader("DecisionServiceABC_DMN12.dmn", org.kie.dmn.core.v1_2.DMNDecisionServicesTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF) && p.getSourceId().equals("_63d05cff-8e3b-4dad-a355-fd88f8bcd613"))).isTrue();
    }

    @Test
    void decisionService20181008() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("DSWithImport20181008-ModelA.dmn"), this.getReader("DSWithImport20181008-ModelB.dmn")});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        List missingDMNImport = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{this.getReader("DSWithImport20181008-ModelA.dmn"), this.getReader("DSWithImport20181008-ModelB-missingDMNImport.dmn")});
        Assertions.assertThat(missingDMNImport.stream().filter(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).hasSize(2);
    }

    @Test
    void invalidFunctionNameInvocation() {
        List validate = validator.validate(this.getReader("invalidFunctionNameInvocation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assertions.assertThat(validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).hasSize(1);
    }

    @Test
    void decisionNoExpr() {
        List validate = validator.validate(this.getReader("noExpr.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat(validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_cdd03786-d1ab-47b5-ba05-df830458dc62"))).hasSize(1);
    }

    @Test
    void validateSchemaAndModels() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{this.getReader("base join.dmn", ImportsTest.class), this.getReader("use join.dmn", ImportsTest.class)});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void dMNv13Simple() {
        List validate = validator.validate(this.getReader("simple.dmn", DMN13specificTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void dMNv13Ch11example1() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("Financial.dmn", DMN13specificTest.class), this.getReader("Chapter 11 Example.dmn", DMN13specificTest.class)});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_4bd33d4a-741b-444a-968b-64e1841211e7"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.ERROR && p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_96b30012-a6e7-4545-89d3-068ec722469c"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
    }

    @Test
    void somethingInBetweenOC() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("somethingInBetween.dmn")});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.ERROR && p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL) && p.getSourceId().equals("_841ed91c-db69-401e-890b-08a5bf44222d"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
    }

    @Test
    void dMNv13Ch11example2() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("Recommended Loan Products.dmn", DMN13specificTest.class), this.getReader("Loan info.dmn", DMN13specificTest.class)});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    void dttyperef() {
        List validate = validator.validate(this.getReader("wrongxml/dttyperef.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        DMNMessage v0 = (DMNMessage)validate.get(0);
        Assertions.assertThat((Comparable)v0.getLevel()).isEqualTo((Object)Message.Level.ERROR);
        Assertions.assertThat((Comparable)v0.getMessageType()).isEqualTo((Object)DMNMessageType.MISSING_TYPE_REF);
        Assertions.assertThat((String)v0.getSourceId()).isEqualTo("_99FC159F-0D94-45C3-A9BD-F1388017A5D4");
    }

    @Test
    void bkmAndBindingWarnLevel() {
        List validate = validator.validate(this.getReader("bkmAndBinding.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().allMatch(p -> p.getLevel() == Message.Level.WARNING)).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getSourceId() != null && p.getSourceId().equals("_3ce3c41a-450a-40d1-9e9c-09180cd29879"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && ((DMNElement)((DMNModelInstrumentedBase)p.getSourceReference()).getParent()).getId().equals("_d8b0c243-3fb6-40ec-a29c-28f8bdb92e13"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
    }

    @Test
    void informationItemMissingTypeRefSC() {
        this.checkInformationItemMissingTypeRef(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_COMPILATION);
    }

    @Test
    void informationItemMissingTypeRefSM() {
        this.checkInformationItemMissingTypeRef(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Test
    void informationItemMissingTypeRefSMC() {
        this.checkInformationItemMissingTypeRef(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION);
    }

    @Test
    void validateAllValidSharedModels() throws IOException {
        String modelFilesPath = "valid_models/";
        URL modelFilesJarURL = Collections.list(Thread.currentThread().getContextClassLoader().getResources("valid_models/")).stream().filter(url -> url.getProtocol().equals("jar")).findFirst().orElseThrow(() -> new RuntimeException("Failed to retrieve jar containing " + modelFilesPath));
        String modelFilesJarFile = modelFilesJarURL.getFile();
        String jarPath = modelFilesJarFile.substring(modelFilesJarFile.lastIndexOf(":") + 1, modelFilesJarFile.lastIndexOf("!"));
        JarFile jarFile = new JarFile(new File(jarPath));
        this.testDirectoryInJar(jarFile, modelFilesPath);
    }

    private void testDirectoryInJar(JarFile jarFile, String directory) {
        List<String> allFiles = Collections.list(jarFile.entries()).stream().filter(entry -> entry.getName().startsWith(directory) && !entry.isDirectory()).map(ZipEntry::getName).toList();
        this.testFiles(allFiles);
    }

    private void testFiles(List<String> modelFiles) {
        Resource[] resources = (Resource[])modelFiles.stream().map(ClassPathResource::new).toArray(value -> new Resource[modelFiles.size()]);
        List dmnMessages = validatorBuilder.theseModels(resources);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)dmnMessages);
        dmnMessages.forEach(dmnMessage -> LOGGER.error(dmnMessage.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dmnMessages.isEmpty());
    }

    private Definitions utilDefinitions(String filename) {
        Definitions definitions;
        DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();
        InputStreamReader isr = new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(filename)));
        try {
            Definitions definitions2 = marshaller.unmarshal((Reader)isr);
            Assertions.assertThat((Object)definitions2).isNotNull();
            definitions = definitions2;
        }
        catch (Throwable definitions2) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable) {
                    definitions2.addSuppressed(throwable);
                }
                throw definitions2;
            }
            catch (IOException e) {
                String messageToShow = e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : String.format("Unable to find file %s", filename);
                LOGGER.error(messageToShow);
                LOGGER.debug(messageToShow, (Throwable)e);
                Assertions.fail((String)String.format("Unable for the test suite to locate the file %s for validation.", filename));
                return null;
            }
        }
        isr.close();
        return definitions;
    }

    private void checkInformationItemMissingTypeRef(DMNValidator.Validation ... options) {
        List validate = validator.validate(this.getReader("variableMissingTypeRef.dmn"), options);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().allMatch(p -> p.getLevel() == Message.Level.WARNING && p.getSourceId().equals("_FE47213A-2042-49DE-9A44-65831DA6AD11"))).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isTrue();
    }
}

