/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

class BuiltinAndOtherValuesTest
extends AbstractDTAnalysisTest {
    BuiltinAndOtherValuesTest() {
    }

    @Test
    void complexDTdates() {
        List validate = validator.validate(this.getReader("complexDTdates.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_a8a4362e-9f2d-4051-9bd6-e7356244f6b7");
        this.checkComplexDTDates(analysis);
    }

    @Test
    void complexDTdatesV2() {
        List validate = validator.validate(this.getReader("complexDTdatesV2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_a8a4362e-9f2d-4051-9bd6-e7356244f6b7");
        this.checkComplexDTDates(analysis);
    }

    private void checkComplexDTDates(DTAnalysis analysis) {
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(2);
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)LocalDate.parse("2019-03-31"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)LocalDate.parse("2019-03-31"), Range.RangeBoundary.CLOSED, null)))), new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)LocalDate.parse("2019-12-31"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)LocalDate.parse("2019-12-31"), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(2);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        List<Overlap> overlaps = List.of(new Overlap(Arrays.asList(2, 3), new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)LocalDate.parse("2019-06-30"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)LocalDate.parse("2019-06-30"), Range.RangeBoundary.CLOSED, null))))));
        Assertions.assertThat(overlaps).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
    }

    @Test
    void weirdPosNeg() {
        List validate = validator.validate(this.getReader("weirdPosNeg.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_54ae95be-6866-4dc1-8c10-1c5a4dd15c93");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }

    @Test
    void weirdYMduration() {
        List validate = validator.validate(this.getReader("weirdYMduration.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = BuiltinAndOtherValuesTest.getAnalysis(validate, "_fe7d267b-d770-461e-8300-e09981147341");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)ComparablePeriod.parse((CharSequence)"P1M"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)ComparablePeriod.parse((CharSequence)"P1M"), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }
}

