/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Contraction;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

class Check2ndNFViolationTest
extends AbstractDTAnalysisTest {
    Check2ndNFViolationTest() {
    }

    @Test
    void check2ndNFViolation() {
        List validate = validator.validate(this.getReader("DT2ndNFViolation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_4e358bae-7012-42dd-acea-e88b3aa3c8b2");
        Assertions.assertThat((boolean)analysis.is2ndNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysis.getContractionsViolating2ndNF()).hasSize(1);
        Contraction c2NFViolation = (Contraction)analysis.getContractionsViolating2ndNF().iterator().next();
        Assertions.assertThat((int)c2NFViolation.rule).isEqualTo(1);
        Assertions.assertThat((List)c2NFViolation.pairedRules).contains((Object[])new Integer[]{2});
        Assertions.assertThat((int)c2NFViolation.adjacentDimension).isEqualTo(3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_4e358bae-7012-42dd-acea-e88b3aa3c8b2") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_2NDNFVIOLATION))).as("It should contain at DMNMessage for the 2nd NF Violation", new Object[0])).isTrue();
    }

    @Test
    void check2ndNFViolation3combo() {
        List validate = validator.validate(this.getReader("DT2ndNF3combo.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_BA703D04-803A-44AA-8A31-F5EEDD4FD54E");
        Assertions.assertThat((boolean)analysis.is2ndNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysis.getContractionsViolating2ndNF()).hasSize(2);
    }

    @Test
    void check2ndNFViolationWasADash() {
        List validate = validator.validate(this.getReader("DT2ndNFWasADash.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_C40525EF-9735-410B-A070-E0336E108268");
        Assertions.assertThat((boolean)analysis.is2ndNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysis.getCellsViolating2ndNF()).hasSize(1);
    }

    @Test
    void check2ndNFViolationWasADash2() {
        List validate = validator.validate(this.getReader("DT2ndNFWasADash2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check2ndNFViolationTest.getAnalysis(validate, "_D3F1D5B8-642B-446D-9099-DE4CB978CB94");
        Assertions.assertThat((boolean)analysis.is2ndNFViolation()).isTrue();
        Assertions.assertThat((Collection)analysis.getCellsViolating2ndNF()).hasSize(1);
    }
}

