/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

class NotTest
extends AbstractDTAnalysisTest {
    NotTest() {
    }

    @Test
    void notString() {
        List validate = validator.validate(this.getReader("DTusingNOT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NotTest.getAnalysis(validate, "_b53fac34-fb12-4601-8605-c226e68292f9");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"i"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"o"), Range.RangeBoundary.OPEN, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        List<Overlap> overlaps = List.of(new Overlap(Arrays.asList(1, 2), new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"o"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"u"), Range.RangeBoundary.OPEN, null))))));
        Assertions.assertThat(overlaps).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
    }

    @Test
    void notString2() {
        List validate = validator.validate(this.getReader("DTusingNOT2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NotTest.getAnalysis(validate, "_b53fac34-fb12-4601-8605-c226e68292f9");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"i"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"o"), Range.RangeBoundary.OPEN, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }

    @Test
    void notStringVowel() {
        List validate = validator.validate(this.getReader("NotStringVowel.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NotTest.getAnalysis(validate, "_406133D7-96FE-4237-8726-44D839F400D6");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }

    @Test
    void notStringVowel2() {
        List validate = validator.validate(this.getReader("NotStringVowel2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NotTest.getAnalysis(validate, "_406133D7-96FE-4237-8726-44D839F400D6");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
        Assertions.assertThat((List)validate).hasSize(1);
        Assertions.assertThat((List)validate).anyMatch(m -> m.getText().contains("string values which can be enumerated for the inputs; Gap analysis skipped"));
    }

    @Test
    void nOTnumber() {
        List validate = validator.validate(this.getReader("DTusingNOTnumber.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NotTest.getAnalysis(validate, "_d0cbacca-55d4-47dd-acc6-131add2a8a53");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        List<Overlap> overlaps = List.of(new Overlap(Arrays.asList(1, 2), new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))));
        Assertions.assertThat(overlaps).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
    }
}

