/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.GapsXYTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

class NullTest
extends AbstractDTAnalysisTest {
    NullTest() {
    }

    @Test
    void nullBooleanBefore() {
        List validate = validator.validate(this.getReader("NullBooleanBefore.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullBoolean(validate);
    }

    @Test
    void nullBooleanAfter() {
        List validate = validator.validate(this.getReader("NullBooleanAfter.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullBoolean(validate);
    }

    private void checkNullBoolean(List<DMNMessage> validate) {
        DTAnalysis analysis = NullTest.getAnalysis(validate, "_76FABA99-C6D0-4C83-81BF-92E807DBDEF8");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }

    @Test
    void nullNumberBefore() {
        List validate = validator.validate(this.getReader("NullNumberBefore.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullNumber(validate);
    }

    @Test
    void nullNumberAfter() {
        List validate = validator.validate(this.getReader("NullNumberAfter.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkNullNumber(validate);
    }

    private void checkNullNumber(List<DMNMessage> validate) {
        DTAnalysis analysis = NullTest.getAnalysis(validate, "_76FABA99-C6D0-4C83-81BF-92E807DBDEF8");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(1);
        List<Hyperrectangle> gaps = List.of(new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)))));
        Assertions.assertThat(gaps).hasSize(1);
        Assertions.assertThat((Collection)analysis.getGaps()).containsAll(gaps);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(0);
    }

    @Test
    void gapsXYv2WithNull() {
        List validate = validator.validate(this.getReader("GapsXYv2WithNull.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        GapsXYTest.checkAnalysis(validate);
    }

    @Test
    void notNullAndEmptyRule() {
        List validate = validator.validate(this.getReader("notnulltest.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NullTest.getAnalysis(validate, "_850C5F03-DA51-4DE7-89E4-61D2C502A03E");
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        Hyperrectangle overlap = new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))));
        Assertions.assertThat((Object)((Overlap)analysis.getOverlaps().get(0)).getOverlap()).isEqualTo((Object)overlap);
    }

    @Test
    void nullsWithActiveRules() {
        List validate = validator.validate(this.getReader("nulltestdt.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = NullTest.getAnalysis(validate, "decisiontablewithnulls");
        Assertions.assertThat((List)analysis.getOverlaps()).isEmpty();
        Assertions.assertThat((Collection)analysis.getGaps()).isEmpty();
        Assertions.assertThat((List)validate).hasSize(1);
    }
}

