/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class OverlapHitPolicyTest
extends AbstractDTAnalysisTest {
    public HitPolicy hp;

    public static Collection<HitPolicy> data() {
        return Arrays.asList(HitPolicy.values()).stream().filter(hp -> hp != HitPolicy.COLLECT).collect(Collectors.toList());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest(name="using {0}")
    public void overlapHitPolicy(HitPolicy hp) {
        this.initOverlapHitPolicyTest(hp);
        Definitions definitions = this.getDefinitions("OverlapHitPolicy.dmn", "https://github.com/kiegroup/drools/kie-dmn/_3010653A-DD3F-4C88-89DA-3FDD845F6604", "OverlapHitPolicy");
        ((DecisionTable)((Decision)definitions.getDrgElement().get(0)).getExpression()).setHitPolicy(hp);
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkAnalysis(validate);
        if (hp == HitPolicy.UNIQUE) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_UNIQUE))).as("It should contain at least 1 DMNMessage for the type", new Object[0])).isTrue();
        } else if (hp == HitPolicy.ANY) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_ANY))).as("It should contain at least 1 DMNMessage for the type", new Object[0])).isTrue();
        } else {
            LOG.debug("Testing for {} I am expecting there is NOT DMNMessage pertaining to Overlaps", (Object)hp);
            Assertions.assertThat((validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_UNIQUE)) && validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_ANY)) && validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_OVERLAP)) ? 1 : 0) != 0).isTrue();
        }
    }

    private void checkAnalysis(List<DMNMessage> validate) {
        DTAnalysis analysis = OverlapHitPolicyTest.getAnalysis(validate, "_C4A1625B-0606-4F2D-9779-49B1A981718E");
        Assertions.assertThat((Collection)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        List<Overlap> overlaps = List.of(new Overlap(Arrays.asList(2, 3), new Hyperrectangle(1, List.of(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("30"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("30"), Range.RangeBoundary.CLOSED, null))))));
        Assertions.assertThat(overlaps).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
    }

    public void initOverlapHitPolicyTest(HitPolicy hp) {
        this.hp = hp;
    }
}

