/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.v1_5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMN15ValidationsTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMN15ValidationsTest.class);
    static final DMNValidator validator = DMNValidatorFactory.newValidator(List.of(new ExtendedDMNProfile()));
    static final DMNValidator.ValidatorBuilder validatorBuilder = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});

    @Test
    void overridingUnnamedImportValidation() {
        String importedModelFileName = "valid_models/DMNv1_5/Imported_Model_Unamed.dmn";
        String importingModelFileName = "valid_models/DMNv1_5/Importing_OverridingEmptyNamed_Model.dmn";
        String modelName = "Importing empty-named Model";
        String modelNamespace = "http://www.trisotech.com/dmn/definitions/_f79aa7a4-f9a3-410a-ac95-bea496edabgc";
        this.validate(importedModelFileName, importingModelFileName);
        Map<String, Object> inputData = Map.of("A Person", DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"Hugh"), DynamicTypeUtils.entry((Object)"age", (Object)32)}));
        this.evaluate(modelNamespace, modelName, importingModelFileName, inputData, importedModelFileName);
    }

    @Test
    void namedImportValidation() {
        String importedModelFileName = "valid_models/DMNv1_5/Imported_Model_Unamed.dmn";
        String importingModelFileName = "valid_models/DMNv1_5/Importing_Named_Model.dmn";
        String modelName = "Importing named Model";
        String modelNamespace = "http://www.trisotech.com/dmn/definitions/_f79aa7a4-f9a3-410a-ac95-bea496edabgc";
        this.validate(importedModelFileName, importingModelFileName);
        Map<String, Object> inputData = Map.of("A Person", DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"Hugh"), DynamicTypeUtils.entry((Object)"age", (Object)32)}));
        this.evaluate(modelNamespace, modelName, importingModelFileName, inputData, importedModelFileName);
    }

    @Test
    void unnamedImportValidationWithHrefNamespace() {
        this.commonUnnamedImportValidation("valid_models/DMNv1_5/Importing_EmptyNamed_Model_With_Href_Namespace.dmn", "valid_models/DMNv1_5/Imported_Model_Unamed.dmn");
    }

    @Test
    void unnamedImportValidationWithoutHrefNamespace() {
        this.commonUnnamedImportValidation("valid_models/DMNv1_5/Importing_EmptyNamed_Model_Without_Href_Namespace.dmn", "valid_models/DMNv1_5/Imported_Model_Unamed.dmn");
    }

    @Test
    void forLoopDatesEvaluateValidation() {
        String modelFileName = "valid_models/DMNv1_5/ForLoopDatesEvaluate.dmn";
        String modelName = "For Loop Dates Evaluate";
        String modelNamespace = "http://www.trisotech.com/dmn/definitions/_09E8A38A-AD24-4C3D-8307-029C0C4D373F";
        this.validate(modelFileName, new String[0]);
        this.evaluate(modelNamespace, modelName, modelFileName, Collections.EMPTY_MAP, new String[0]);
    }

    @Test
    void listReplaceEvaluateValidation() {
        String modelFileName = "valid_models/DMNv1_5/ListReplaceEvaluate.dmn";
        String modelName = "List Replace Evaluate";
        String modelNamespace = "http://www.trisotech.com/dmn/definitions/_09E8A38A-AD24-4C3D-8307-029C0C4D373F";
        this.validate(modelFileName, new String[0]);
        this.evaluate(modelNamespace, modelName, modelFileName, Collections.EMPTY_MAP, new String[0]);
    }

    @Test
    void negationOfDurationEvaluateValidation() {
        String modelFileName = "valid_models/DMNv1_5/NegationOfDurationEvaluate.dmn";
        String modelName = "Negation of Duration Evaluate";
        String modelNamespace = "http://www.trisotech.com/dmn/definitions/_09E8A38A-AD24-4C3D-8307-029C0C4D373F";
        this.validate(modelFileName, new String[0]);
        this.evaluate(modelNamespace, modelName, modelFileName, Collections.EMPTY_MAP, new String[0]);
    }

    @Test
    void dateToDateTimeFunctionValidation() {
        String modelFileName = "valid_models/DMNv1_5/DateToDateTimeFunction.dmn";
        String modelName = "new-file";
        String modelNamespace = "https://kiegroup.org/dmn/_A7F17D7B-F0AB-4C0B-B521-02EA26C2FBEE";
        this.validate(modelFileName, new String[0]);
        this.evaluate(modelNamespace, modelName, modelFileName, Collections.EMPTY_MAP, new String[0]);
    }

    @Test
    void typeConstraintsChecksValidation() {
        String modelFileName = "valid_models/DMNv1_5/TypeConstraintsChecks.dmn";
        String modelName = "TypeConstraintsChecks";
        String modelNamespace = "http://www.trisotech.com/definitions/_238bd96d-47cd-4746-831b-504f3e77b442";
        this.validate(modelFileName, new String[0]);
        Map<String, Object> inputData = Map.of("p1", DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Name", (Object)"P1"), DynamicTypeUtils.entry((Object)"Interests", Collections.singletonList("Golf"))}));
        this.evaluate(modelNamespace, modelName, modelFileName, inputData, new String[0]);
    }

    private void commonUnnamedImportValidation(String importingModelRef, String importedModelRef) {
        String modelName = "Importing empty-named Model";
        String modelNamespace = "http://www.trisotech.com/dmn/definitions/_f79aa7a4-f9a3-410a-ac95-bea496edabgc";
        this.validate(importingModelRef, importedModelRef);
        Map<String, Object> inputData = Map.of("A Person", DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"Hugh"), DynamicTypeUtils.entry((Object)"age", (Object)32)}));
        this.evaluate(modelNamespace, modelName, importingModelRef, inputData, importedModelRef);
    }

    private void validate(String modelFileName, String ... otherFileNames) {
        ArrayList<String> allModelsFileNames = new ArrayList<String>();
        allModelsFileNames.add(modelFileName);
        allModelsFileNames.addAll(List.of(otherFileNames));
        Resource[] resources = (Resource[])allModelsFileNames.stream().map(fileName -> new ClassPathResource(fileName, this.getClass())).toArray(value -> new Resource[allModelsFileNames.size()]);
        List dmnMessages = validatorBuilder.theseModels(resources);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)dmnMessages);
        dmnMessages.forEach(dmnMessage -> LOG.error(dmnMessage.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dmnMessages.isEmpty());
    }

    private void evaluate(String modelNamespace, String modelName, String modelFileName, Map<String, Object> inputData, String ... otherFileNames) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)modelFileName, this.getClass(), (String[])otherFileNames);
        DMNModel dmnModel = runtime.getModel(modelNamespace, modelName);
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx = runtime.newContext();
        inputData.forEach((arg_0, arg_1) -> ((DMNContext)ctx).set(arg_0, arg_1));
        DMNResult toReturn = runtime.evaluateAll(dmnModel, ctx);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)toReturn.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)toReturn.getMessages()), new Object[0])).isFalse();
    }
}

