/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.marshalling.v1_1.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.DMNInputRuntimeTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.v1_1.Context;
import org.kie.dmn.model.v1_1.ContextEntry;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;

public class ValidatorTest {
    private static DMNValidator validator;

    @BeforeClass
    public static void init() {
        validator = DMNValidatorFactory.newValidator();
    }

    @AfterClass
    public static void dispose() {
        validator.dispose();
    }

    @Test
    public void testDryRun() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Definitions definitions = dmnModel.getDefinitions();
        Assert.assertThat((Object)definitions, (Matcher)CoreMatchers.notNullValue());
        DMNValidatorFactory.newValidator().validate(definitions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Definitions utilDefinitions(String filename, String modelName) {
        DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();
        try (InputStreamReader isr = new InputStreamReader(this.getClass().getResourceAsStream(filename));){
            Definitions definitions2 = marshaller.unmarshal((Reader)isr);
            Assert.assertThat((Object)definitions2, (Matcher)CoreMatchers.notNullValue());
            Definitions definitions = definitions2;
            return definitions;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unable for the test suite to locate the file for validation.");
            return null;
        }
    }

    private Reader getReader(String filename) {
        return new InputStreamReader(this.getClass().getResourceAsStream(filename));
    }

    @Test
    public void testInvalidXml() throws URISyntaxException {
        List validateXML = validator.validate(new File(this.getClass().getResource("invalidXml.dmn").toURI()), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA});
        Assert.assertThat((String)this.formatMessages(validateXML), (Object)validateXML.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validateXML.get(0)).toString(), (Object)((DMNMessage)validateXML.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.FAILED_XML_VALIDATION));
    }

    @Test
    public void testBKM_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("BKM_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
    }

    @Test
    public void testDECISION_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("DECISION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
    }

    @Test
    public void testINVOCATION_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("INVOCATION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
    }

    @Test
    public void testCONTEXT_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("CONTEXT_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testCONTEXT_MISSING_ENTRIES() {
        List validate = validator.validate(this.getReader("CONTEXT_MISSING_ENTRIES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testCONTEXT_ENTRY_MISSING_VARIABLE() {
        List validate = validator.validate(this.getReader("CONTEXT_ENTRY_MISSING_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
        ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
        Assert.assertThat((Object)((Context)ce.getParent()).getContextEntry().indexOf(ce), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testBKM_MISSING_VAR() {
        List validate = validator.validate(this.getReader("BKM_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISSING_VAR() {
        List validate = validator.validate(this.getReader("DECISION_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISSING_VARbis() {
        List validate = validator.validate(this.getReader("DECISION_MISSING_VARbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testINPUT_MISSING_VAR() {
        List validate = validator.validate(this.getReader("INPUTDATA_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testBKM_MISMATCH_VAR() {
        List validate = validator.validate(this.getReader("BKM_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testDECISION_MISMATCH_VAR() {
        List validate = validator.validate(this.getReader("DECISION_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testINPUT_MISMATCH_VAR() {
        List validate = validator.validate(this.getReader("INPUTDATA_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testTYPEREF_NO_NS() throws URISyntaxException {
        List validate = validator.validate(this.getReader("TYPEREF_NO_NS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND)));
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF() {
        List validate = validator.validate(this.getReader("TYPEREF_NOT_FEEL_NOT_DEF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND)));
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_valid() {
        List validate = validator.validate(this.getReader("TYPEREF_NOT_FEEL_NOT_DEF_valid.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testNAME_INVALID() {
        List validate = validator.validate(this.getReader("NAME_INVALID.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
    }

    @Test
    public void testNAME_INVALID_bis() {
        List validate = validator.validate(this.getReader("NAME_INVALID_bis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
    }

    @Test
    public void testNAME_INVALID_empty_name() {
        List validate = validator.validate(this.getReader("DROOLS-1447.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_5e43b55c-888e-443c-b1b9-80e4aa6746bd")));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_b1e4588e-9ce1-4474-8e4e-48dbcdb7524b")));
    }

    @Test
    public void testCONTEXT_DUP_ENTRY() {
        List validate = validator.validate(this.getReader("CONTEXT_DUP_ENTRY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME)));
    }

    @Test
    public void testCONTEXT_ENTRY_NOTYPEREF() {
        List validate = validator.validate(this.getReader("CONTEXT_ENTRY_NOTYPEREF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
    }

    @Test
    public void testDRGELEM_NOT_UNIQUE() {
        List validate = validator.validate(this.getReader("DRGELEM_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME)));
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_NAME() {
        List validate = validator.validate(this.getReader("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
    }

    @Test
    public void testDTABLE_PRIORITY_MISSING_OUTVALS() {
        List validate = validator.validate(this.getReader("DTABLE_PRIORITY_MISSING_OUTVALS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES)));
    }

    @Test
    public void testDTABLE_SINGLEOUT_NONAME() {
        List validate = validator.validate(this.getReader("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF)));
    }

    @Test
    public void testELEMREF_MISSING_TARGET() {
        List validate = validator.validate(this.getReader("ELEMREF_MISSING_TARGET.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testELEMREF_NOHASH() {
        List validate = validator.validate(this.getReader("ELEMREF_NOHASH.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        System.out.println(this.formatMessages(validate));
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_HREF_SYNTAX)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testFORMAL_PARAM_DUPLICATED() {
        List validate = validator.validate(this.getReader("FORMAL_PARAM_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_PARAM)));
    }

    @Test
    public void testINVOCATION_INCONSISTENT_PARAM_NAMES() {
        List validate = validator.validate(this.getReader("INVOCATION_INCONSISTENT_PARAM_NAMES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH)));
    }

    @Test
    @Ignore(value="Needs to be improved as invocations can be used to invoke functions node defined in BKMs. E.g., FEEL built in functions, etc.")
    public void testINVOCATION_MISSING_TARGET() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGET.dmn", "INVOCATION_MISSING_TARGET");
        List validate = validator.validate(definitions);
    }

    @Ignore(value="known current limitation")
    @Test
    public void testINVOCATION_MISSING_TARGETRbis() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGETbis.dmn", "INVOCATION_MISSING_TARGETbis");
        List validate = validator.validate(definitions);
    }

    @Test
    public void testINVOCATION_WRONG_PARAM_COUNT() {
        List validate = validator.validate(this.getReader("INVOCATION_WRONG_PARAM_COUNT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH)));
    }

    @Test
    public void testITEMCOMP_DUPLICATED() {
        List validate = validator.validate(this.getReader("ITEMCOMP_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF)));
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF)));
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE_DROOLS_1450() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE_DROOLS-1450.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testRELATION_DUP_COLUMN() {
        List validate = validator.validate(this.getReader("RELATION_DUP_COLUMN.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_RELATION_COLUMN)));
    }

    @Test
    public void testRELATION_ROW_CELL_NOTLITERAL() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELL_NOTLITERAL.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_NOT_LITERAL)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testRELATION_ROW_CELLCOUNTMISMATCH() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELLCOUNTMISMATCH.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_COUNT_MISMATCH)));
    }

    @Test
    public void testREQAUTH_NOT_KNOWLEDGESOURCE() {
        List validate = validator.validate(this.getReader("REQAUTH_NOT_KNOWLEDGESOURCE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testMortgageRecommender() {
        List validate = validator.validate(this.getReader("MortgageRecommender.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testREQAUTH_NOT_KNOWLEDGESOURCEbis() {
        List validate = validator.validate(this.getReader("REQAUTH_NOT_KNOWLEDGESOURCEbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testTYPEREF_NO_FEEL_TYPE() {
        List validate = validator.validate(this.getReader("TYPEREF_NO_FEEL_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_REF_NOT_FOUND)));
    }

    @Test
    public void testVARIABLE_LEADING_TRAILING_SPACES() {
        List validate = validator.validate(this.getReader("VARIABLE_LEADING_TRAILING_SPACES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
        Assert.assertThat((Object)((DMNMessage)validate.get(0)).getSourceId(), (Matcher)CoreMatchers.is((Object)"_dd662d27-7896-42cb-9d14-bd74203bdbec"));
    }

    @Test
    public void testUNKNOWN_VARIABLE() {
        List validate = validator.validate(this.getReader("UNKNOWN_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)this.formatMessages(validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL)));
    }

    private String formatMessages(List<DMNMessage> messages) {
        return messages.stream().map(m -> m.toString()).collect(Collectors.joining("\n"));
    }
}

