/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

@RunWith(value=Parameterized.class)
public class OverlapHitPolicyTest
extends AbstractDTAnalysisTest {
    @Parameterized.Parameter
    public HitPolicy hp;

    @Parameterized.Parameters(name="using {0}")
    public static Collection<HitPolicy> data() {
        return Arrays.asList(HitPolicy.values());
    }

    @Test
    public void testOverlapHitPolicy() {
        Definitions definitions = this.getDefinitions("OverlapHitPolicy.dmn", "https://github.com/kiegroup/drools/kie-dmn/_3010653A-DD3F-4C88-89DA-3FDD845F6604", "OverlapHitPolicy");
        ((DecisionTable)((Decision)definitions.getDrgElement().get(0)).getExpression()).setHitPolicy(this.hp);
        List validate = validator.validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkAnalysis(validate);
        DMNMessageType msg = null;
        switch (this.hp) {
            case UNIQUE: {
                msg = DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_UNIQUE;
                break;
            }
            case ANY: {
                msg = DMNMessageType.DECISION_TABLE_OVERLAP_HITPOLICY_ANY;
                break;
            }
            default: {
                msg = DMNMessageType.DECISION_TABLE_OVERLAP;
            }
        }
        DMNMessageType whichMsg = msg;
        LOG.debug("Testing for {} I am expecting a DMNMessage of type {}", (Object)this.hp, (Object)whichMsg);
        Assert.assertTrue((String)("It should contain at least 1 DMNMessage for the type " + whichMsg), (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)whichMsg)));
    }

    private void checkAnalysis(List<DMNMessage> validate) {
        DTAnalysis analysis = this.getAnalysis(validate, "_C4A1625B-0606-4F2D-9779-49B1A981718E");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)1));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(2, 3), new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("30"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("30"), Range.RangeBoundary.CLOSED, null))))));
        Assert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
    }
}

