/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class DTAnalysisMeta {
    public static Expression printGaps(DTAnalysis analysis) {
        Collection gaps = analysis.getGaps();
        MethodCallExpr parseExpression = (MethodCallExpr)JavaParser.parseExpression((String)"Arrays.asList()");
        for (Hyperrectangle gap : gaps) {
            Expression gapAsExpression = DTAnalysisMeta.hrAsExpression(gap);
            parseExpression.addArgument(gapAsExpression);
        }
        return parseExpression;
    }

    public static Expression printOverlaps(DTAnalysis analysis) {
        List overlaps = analysis.getOverlaps();
        MethodCallExpr parseExpression = (MethodCallExpr)JavaParser.parseExpression((String)"Arrays.asList()");
        for (Overlap overlap : overlaps) {
            Expression overlapAsExpression = DTAnalysisMeta.overlapAsExpression(overlap);
            parseExpression.addArgument(overlapAsExpression);
        }
        return parseExpression;
    }

    private static Expression overlapAsExpression(Overlap overlap) {
        MethodCallExpr edgesExpression = (MethodCallExpr)JavaParser.parseExpression((String)"Arrays.asList()");
        for (Number edge : overlap.getRules()) {
            edgesExpression.addArgument((Expression)new IntegerLiteralExpr(edge.intValue()));
        }
        ObjectCreationExpr newExpression = (ObjectCreationExpr)JavaParser.parseExpression((String)"new Overlap()");
        newExpression.addArgument((Expression)edgesExpression);
        newExpression.addArgument(DTAnalysisMeta.hrAsExpression(overlap.getOverlap()));
        return newExpression;
    }

    private static Expression hrAsExpression(Hyperrectangle gap) {
        int dimensions = gap.getDimensions();
        MethodCallExpr edgesExpression = (MethodCallExpr)JavaParser.parseExpression((String)"Arrays.asList()");
        for (Interval edge : gap.getEdges()) {
            Expression intervalAsExpression = DTAnalysisMeta.intervalAsExpression(edge);
            edgesExpression.addArgument(intervalAsExpression);
        }
        ObjectCreationExpr newExpression = (ObjectCreationExpr)JavaParser.parseExpression((String)"new Hyperrectangle()");
        newExpression.addArgument((Expression)new IntegerLiteralExpr(dimensions));
        newExpression.addArgument((Expression)edgesExpression);
        return newExpression;
    }

    private static Expression intervalAsExpression(Interval edge) {
        MethodCallExpr newExpression = (MethodCallExpr)JavaParser.parseExpression((String)"Interval.newFromBounds()");
        Expression lowerAsExpression = DTAnalysisMeta.boundAsExpression(edge.getLowerBound());
        newExpression.addArgument(lowerAsExpression);
        Expression upperAsExpression = DTAnalysisMeta.boundAsExpression(edge.getUpperBound());
        newExpression.addArgument(upperAsExpression);
        return newExpression;
    }

    private static Expression boundAsExpression(Bound<?> bound) {
        ObjectCreationExpr newExpression;
        Comparable value = bound.getValue();
        Expression valueExpr = null;
        if (value == Interval.NEG_INF) {
            valueExpr = JavaParser.parseExpression((String)"Interval.NEG_INF");
        } else if (value == Interval.POS_INF) {
            valueExpr = JavaParser.parseExpression((String)"Interval.POS_INF");
        } else if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            newExpression = (ObjectCreationExpr)JavaParser.parseExpression((String)"new BigDecimal()");
            StringLiteralExpr stringRep = new StringLiteralExpr(bigDecimal.toString());
            newExpression.addArgument((Expression)stringRep);
            valueExpr = newExpression;
        } else if (value instanceof String) {
            String string = (String)((Object)value);
            newExpression = new StringLiteralExpr();
            newExpression.setString(string);
            valueExpr = newExpression;
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            valueExpr = new BooleanLiteralExpr(b.booleanValue());
        } else {
            throw new UnsupportedOperationException("boundAsExpression value " + value + " not supported.");
        }
        Expression typeExpr = null;
        if (bound.getBoundaryType() == Range.RangeBoundary.OPEN) {
            typeExpr = JavaParser.parseExpression((String)"RangeBoundary.OPEN");
        } else if (bound.getBoundaryType() == Range.RangeBoundary.CLOSED) {
            typeExpr = JavaParser.parseExpression((String)"RangeBoundary.CLOSED");
        } else {
            throw new IllegalStateException("illegal getBoundaryType");
        }
        newExpression = (ObjectCreationExpr)JavaParser.parseExpression((String)"new Bound()");
        newExpression.addArgument(valueExpr);
        newExpression.addArgument(typeExpr);
        newExpression.addArgument((Expression)new NullLiteralExpr());
        return newExpression;
    }
}

