/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.List;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTAOutputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTARule;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class DDTATable {
    private List<DDTAInputClause> inputs = new ArrayList<DDTAInputClause>();
    private List<DDTARule> rules = new ArrayList<DDTARule>();
    private List<DDTAOutputClause> outputs = new ArrayList<DDTAOutputClause>();

    public List<DDTAInputClause> getInputs() {
        return this.inputs;
    }

    public List<DDTARule> getRule() {
        return this.rules;
    }

    public int inputCols() {
        return this.inputs.size();
    }

    public int inputRules() {
        return this.rules.size();
    }

    public List<Interval> projectOnColumnIdx(int jColIdx) {
        ArrayList<Interval> results = new ArrayList<Interval>();
        for (DDTARule r : this.rules) {
            DDTAInputEntry ieX = r.getInputEntry().get(jColIdx);
            results.addAll(ieX.getIntervals());
        }
        return results;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DDTATable [rules=");
        this.rules.forEach(r -> builder.append("\n" + r));
        builder.append("\n]");
        return builder.toString();
    }

    public List<DDTAOutputClause> getOutputs() {
        return this.outputs;
    }

    public int outputCols() {
        return this.outputs.size();
    }
}

