/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.ast.DashNode;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.HitPolicy;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalysisMessage;
import org.kie.dmn.validation.dtanalysis.model.DDTAInputEntry;
import org.kie.dmn.validation.dtanalysis.model.DDTAOutputClause;
import org.kie.dmn.validation.dtanalysis.model.DDTATable;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MaskedRule;
import org.kie.dmn.validation.dtanalysis.model.MisleadingRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class DTAnalysis {
    private final List<Hyperrectangle> gaps = new ArrayList<Hyperrectangle>();
    private final List<Overlap> overlaps = new ArrayList<Overlap>();
    private final List<MaskedRule> maskedRules = new ArrayList<MaskedRule>();
    private final List<MisleadingRule> misleadingRules = new ArrayList<MisleadingRule>();
    private final DecisionTable sourceDT;
    private final Throwable error;
    private final DDTATable ddtaTable;
    private final Collection passThruMessages = new ArrayList();

    public DTAnalysis(DecisionTable sourceDT, DDTATable ddtaTable) {
        this.sourceDT = sourceDT;
        this.error = null;
        this.ddtaTable = ddtaTable;
    }

    private DTAnalysis(DecisionTable sourceDT, Throwable error) {
        this.sourceDT = sourceDT;
        this.error = error;
        this.ddtaTable = null;
    }

    public static DTAnalysis ofError(DecisionTable sourceDT, Throwable error) {
        return new DTAnalysis(sourceDT, error);
    }

    public boolean isError() {
        return this.error != null;
    }

    public DDTATable getDdtaTable() {
        return this.ddtaTable;
    }

    public Collection<Hyperrectangle> getGaps() {
        return Collections.unmodifiableList(this.gaps);
    }

    public void addGap(Hyperrectangle gap) {
        this.gaps.add(gap);
    }

    public DMNModelInstrumentedBase getSource() {
        return this.sourceDT;
    }

    public List<Overlap> getOverlaps() {
        return Collections.unmodifiableList(this.overlaps);
    }

    public void addOverlap(Overlap overlap) {
        this.overlaps.add(overlap);
    }

    public void normalize() {
        int prevSize = this.overlaps.size();
        this.internalNormalize();
        int curSize = this.overlaps.size();
        if (curSize != prevSize) {
            this.normalize();
        }
    }

    private void internalNormalize() {
        ArrayList<Overlap> newOverlaps = new ArrayList<Overlap>();
        ArrayList<Overlap> overlapsProcessing = new ArrayList<Overlap>();
        overlapsProcessing.addAll(this.overlaps);
        while (!overlapsProcessing.isEmpty()) {
            ArrayList<Overlap> toBeRemoved = new ArrayList<Overlap>();
            ArrayList<Overlap> toBeAdded = new ArrayList<Overlap>();
            Overlap curOverlap = (Overlap)overlapsProcessing.remove(0);
            for (Overlap otherOverlap : overlapsProcessing) {
                if (curOverlap == null) break;
                int x = curOverlap.contigousOnDimension(otherOverlap);
                if (x <= 0) continue;
                Overlap mergedOverlap = Overlap.newByMergeOnDimension(curOverlap, otherOverlap, x);
                curOverlap = null;
                toBeRemoved.add(otherOverlap);
                toBeAdded.add(mergedOverlap);
            }
            for (Overlap x : toBeRemoved) {
                overlapsProcessing.remove(x);
            }
            for (Overlap x : toBeAdded) {
                overlapsProcessing.add(0, x);
            }
            if (curOverlap == null) continue;
            newOverlaps.add(curOverlap);
        }
        this.overlaps.clear();
        this.overlaps.addAll(newOverlaps);
    }

    public List<DMNMessage> asDMNMessages() {
        ArrayList<DMNMessage> results = new ArrayList<DMNMessage>();
        if (this.isError()) {
            DMNDTAnalysisMessage m = new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_ERROR_ANALYSIS_SKIPPED, (Object)this.sourceDT.getOutputLabel(), (Object)this.error.getMessage()), Msg.DTANALYSIS_ERROR_ANALYSIS_SKIPPED.getType());
            results.add((DMNMessage)m);
            return results;
        }
        results.addAll(this.passThruMessages());
        results.addAll(this.gapsAsMessages());
        results.addAll(this.overlapsAsMessages());
        this.warnAboutHitPolicyFirst(results);
        if (results.isEmpty()) {
            DMNDTAnalysisMessage m = new DMNDTAnalysisMessage(this, DMNMessage.Severity.INFO, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_EMPTY, (Object)this.sourceDT.getOutputLabel()), Msg.DTANALYSIS_EMPTY.getType());
            results.add((DMNMessage)m);
            return results;
        }
        return results;
    }

    private void warnAboutHitPolicyFirst(List<DMNMessage> results) {
        if (this.sourceDT.getHitPolicy() == HitPolicy.FIRST) {
            results.add((DMNMessage)new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_HITPOLICY_FIRST, (Object)this.sourceDT.getOutputLabel()), Msg.DTANALYSIS_HITPOLICY_FIRST.getType()));
        }
    }

    private Collection passThruMessages() {
        return this.passThruMessages;
    }

    private Collection overlapsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        block5: for (Overlap overlap : this.overlaps) {
            block0 : switch (this.sourceDT.getHitPolicy()) {
                case UNIQUE: {
                    results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_OVERLAP_HITPOLICY_UNIQUE, (Object)overlap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_OVERLAP_HITPOLICY_UNIQUE.getType()));
                    break;
                }
                case PRIORITY: {
                    for (MaskedRule masked : this.maskedRules) {
                        results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_HITPOLICY_PRIORITY_MASKED_RULE, (Object)masked.maskedRule, (Object)masked.maskedBy), Msg.DTANALYSIS_HITPOLICY_PRIORITY_MASKED_RULE.getType()));
                    }
                    results.add(this.overlapToStandardDMNMessage(overlap));
                    for (MisleadingRule misleading : this.misleadingRules) {
                        results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message2)Msg.DTANALYSIS_HITPOLICY_PRIORITY_MISLEADING_RULE, (Object)misleading.misleadingRule, (Object)misleading.misleadRule), Msg.DTANALYSIS_HITPOLICY_PRIORITY_MISLEADING_RULE.getType()));
                    }
                    continue block5;
                }
                case ANY: {
                    List<Comparable<?>> prevValue = this.ddtaTable.getRule().get(overlap.getRules().get(0) - 1).getOutputEntry();
                    for (int i = 1; i < overlap.getRules().size(); ++i) {
                        int curIndex = overlap.getRules().get(i) - 1;
                        List<Comparable<?>> curValue = this.ddtaTable.getRule().get(curIndex).getOutputEntry();
                        if (!prevValue.equals(curValue)) {
                            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_OVERLAP_HITPOLICY_ANY, (Object)overlap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_OVERLAP_HITPOLICY_ANY.getType()));
                            break block0;
                        }
                        prevValue = curValue;
                    }
                    continue block5;
                }
                default: {
                    results.add(this.overlapToStandardDMNMessage(overlap));
                }
            }
        }
        return results;
    }

    private DMNDTAnalysisMessage overlapToStandardDMNMessage(Overlap overlap) {
        return new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_OVERLAP, (Object)overlap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_OVERLAP.getType());
    }

    private Collection gapsAsMessages() {
        ArrayList<DMNDTAnalysisMessage> results = new ArrayList<DMNDTAnalysisMessage>();
        for (Hyperrectangle gap : this.gaps) {
            results.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message1)Msg.DTANALYSIS_GAP, (Object)gap.asHumanFriendly(this.ddtaTable)), Msg.DTANALYSIS_GAP.getType()));
        }
        return results;
    }

    public void computeMaskedRules() {
        if (this.sourceDT.getHitPolicy() != HitPolicy.PRIORITY) {
            return;
        }
        for (Overlap overlap : this.overlaps) {
            this.analyseOverlapForMaskedRules(overlap);
        }
    }

    private void analyseOverlapForMaskedRules(Overlap overlap) {
        for (Integer ruleId : overlap.getRules()) {
            List<Comparable<?>> curValues = this.ddtaTable.getRule().get(ruleId - 1).getOutputEntry();
            for (int jOutputIdx = 0; jOutputIdx < this.ddtaTable.outputCols(); ++jOutputIdx) {
                DDTAOutputClause curOutputClause = this.ddtaTable.getOutputs().get(jOutputIdx);
                if (!curOutputClause.isDiscreteDomain()) continue;
                int curOutputIdx = curOutputClause.getOutputOrder().indexOf(curValues.get(jOutputIdx));
                ArrayList<Integer> otherRules = new ArrayList<Integer>(overlap.getRules());
                otherRules.remove(ruleId);
                for (Integer otherRuleID : otherRules) {
                    List<Comparable<?>> otherRuleValues = this.ddtaTable.getRule().get(otherRuleID - 1).getOutputEntry();
                    int otherOutputIdx = curOutputClause.getOutputOrder().indexOf(otherRuleValues.get(jOutputIdx));
                    if (curOutputIdx <= otherOutputIdx) continue;
                    try {
                        boolean isOtherRuleWider = this.comparingRulesIsRightWider(ruleId, otherRuleID);
                        if (!isOtherRuleWider) continue;
                        this.maskedRules.add(new MaskedRule(ruleId, otherRuleID));
                    }
                    catch (ComparingRulesWithMultipleInputEntries e) {
                        this.passThruMessages.add(new DMNDTAnalysisMessage(this, DMNMessage.Severity.WARN, MsgUtil.createMessage((Msg.Message3)Msg.DTANALYSIS_HITPOLICY_PRIORITY_ANALYSIS_SKIPPED, (Object)this.sourceDT.getOutputLabel(), (Object)ruleId, (Object)otherRuleID), Msg.DTANALYSIS_HITPOLICY_PRIORITY_ANALYSIS_SKIPPED.getType()));
                    }
                }
            }
        }
    }

    public boolean comparingRulesIsRightWider(int ruleId, int isWiderRuleId) throws ComparingRulesWithMultipleInputEntries {
        boolean isOtherRuleWider = true;
        for (int jInputIdx = 0; isOtherRuleWider && jInputIdx < this.ddtaTable.inputCols(); ++jInputIdx) {
            DDTAInputEntry ruleIdInputAtIdx = this.ddtaTable.getRule().get(ruleId - 1).getInputEntry().get(jInputIdx);
            DDTAInputEntry otherRuleInputAtIdx = this.ddtaTable.getRule().get(isWiderRuleId - 1).getInputEntry().get(jInputIdx);
            if (ruleIdInputAtIdx.getIntervals().size() != 1 || otherRuleInputAtIdx.getIntervals().size() != 1) {
                throw new ComparingRulesWithMultipleInputEntries("Multiple entries not supported");
            }
            Interval ruleIdInterval = ruleIdInputAtIdx.getIntervals().get(0);
            Interval otherRuleInterval = otherRuleInputAtIdx.getIntervals().get(0);
            isOtherRuleWider = isOtherRuleWider && otherRuleInterval.includes(ruleIdInterval);
        }
        return isOtherRuleWider;
    }

    public List<MaskedRule> getMaskedRules() {
        return Collections.unmodifiableList(this.maskedRules);
    }

    public void computeMisleadingRules() {
        if (this.sourceDT.getHitPolicy() != HitPolicy.PRIORITY) {
            return;
        }
        for (Overlap overlap : this.overlaps) {
            this.analyseOverlapForMisleadingRules(overlap);
        }
    }

    private void analyseOverlapForMisleadingRules(Overlap overlap) {
        for (Integer ruleId : overlap.getRules()) {
            List<Comparable<?>> curValues = this.ddtaTable.getRule().get(ruleId - 1).getOutputEntry();
            for (int jOutputIdx = 0; jOutputIdx < this.ddtaTable.outputCols(); ++jOutputIdx) {
                boolean isOutputLowestPriority;
                DDTAOutputClause curOutputClause = this.ddtaTable.getOutputs().get(jOutputIdx);
                if (!curOutputClause.isDiscreteDomain()) continue;
                int curOutputIdx = curOutputClause.getOutputOrder().indexOf(curValues.get(jOutputIdx));
                boolean bl = isOutputLowestPriority = curOutputIdx == curOutputClause.getOutputOrder().size() - 1;
                if (isOutputLowestPriority) continue;
                List<DDTAInputEntry> inputEntry = this.ddtaTable.getRule().get(ruleId - 1).getInputEntry();
                boolean isRuleContainsHypen = inputEntry.stream().flatMap(ie -> ie.getUts().stream()).anyMatch(DashNode.class::isInstance);
                if (!isRuleContainsHypen) continue;
                ArrayList<Integer> otherRules = new ArrayList<Integer>(overlap.getRules());
                otherRules.remove(ruleId);
                for (Integer otherRuleID : otherRules) {
                    List<Comparable<?>> otherRuleValues = this.ddtaTable.getRule().get(otherRuleID - 1).getOutputEntry();
                    int otherOutputIdx = curOutputClause.getOutputOrder().indexOf(otherRuleValues.get(jOutputIdx));
                    if (otherOutputIdx <= curOutputIdx) continue;
                    this.misleadingRules.add(new MisleadingRule(ruleId, otherRuleID));
                }
            }
        }
    }

    public List<MisleadingRule> getMisleadingRules() {
        return Collections.unmodifiableList(this.misleadingRules);
    }

    public class ComparingRulesWithMultipleInputEntries
    extends Exception {
        public ComparingRulesWithMultipleInputEntries(String message) {
            super(message);
        }
    }
}

