/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Contraction;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class ContractionRulesTest
extends AbstractDTAnalysisTest {
    @Test
    public void testContractionRules() {
        List validate = validator.validate(this.getReader("Contraction.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = this.getAnalysis(validate, "_01d9abb9-b968-49c0-b6ab-909f3e03d8d3");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)analysis.getContractions(), (Matcher)Matchers.hasSize((int)2));
        List<Contraction> results = Arrays.asList(new Contraction(4, 5, 2, Arrays.asList(new Interval(Range.RangeBoundary.CLOSED, (Comparable)new BigDecimal("0.35"), Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, 0))), new Contraction(3, 6, 1, Arrays.asList(new Interval(Range.RangeBoundary.CLOSED, (Comparable)new BigDecimal("600"), Interval.POS_INF, Range.RangeBoundary.CLOSED, 0, 0))));
        Assert.assertThat(results, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getContractions(), (Matcher)Matchers.contains((Object[])results.toArray()));
        Assert.assertThat((String)"It should contain 2 DMNMessage for the Contraction", validate.stream().filter(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_CONTRACTION_RULE)).collect(Collectors.toList()), (Matcher)Matchers.hasSize((int)2));
    }
}

